/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.math;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.saintandreas.math.FastMath;
import org.saintandreas.math.Vector;
import org.saintandreas.math.Vector2f;

public final class Vector3f
extends Vector<Vector3f>
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f NAN = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f UNIT_XYZ = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f POSITIVE_INFINITY = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
    public static final Vector3f NEGATIVE_INFINITY = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    public final float x;
    public final float y;
    public final float z;

    public Vector3f() {
        this(0.0f);
    }

    public Vector3f(float s) {
        this.y = this.z = s;
        this.x = this.z;
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(@Nonnull Vector2f v, float z) {
        this(v.x, v.y, z);
    }

    public Vector3f(@Nonnull Vector2f v) {
        this(v, 0.0f);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vector3f cross(Vector3f v) {
        float resX = this.y * v.z - this.z * v.y;
        float resY = this.z * v.x - this.x * v.z;
        float resZ = this.x * v.y - this.y * v.x;
        return new Vector3f(resX, resY, resZ);
    }

    @Override
    public float angleBetween(Vector3f otherVector) {
        float dotProduct = this.dot(otherVector);
        float angle = FastMath.acos(dotProduct);
        return angle;
    }

    @Override
    public float[] toArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector3f)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Vector3f comp = (Vector3f)o;
        if (Float.compare(this.x, comp.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, comp.y) != 0) {
            return false;
        }
        return Float.compare(this.z, comp.z) == 0;
    }

    public float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1 or 2");
    }

    @Override
    protected Vector3f build(float[] v) {
        return new Vector3f(v[0], v[1], v[2]);
    }

    @Override
    protected Vector3f build(float s) {
        return new Vector3f(s);
    }
}

