/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.math;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.saintandreas.math.FastMath;
import org.saintandreas.math.Vector;
import org.saintandreas.math.Vector3f;

public final class Vector2f
extends Vector<Vector2f>
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    public static final Vector2f UNIT_X = new Vector2f(1.0f, 0.0f);
    public static final Vector2f UNIT_Y = new Vector2f(0.0f, 1.0f);
    public static final Vector2f UNIT_XY = new Vector2f(1.0f, 1.0f);
    public final float x;
    public final float y;

    public Vector2f() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(float s) {
        this.x = s;
        this.y = s;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector2f)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Vector2f comp = (Vector2f)o;
        if (Float.compare(this.x, comp.x) != 0) {
            return false;
        }
        return Float.compare(this.y, comp.y) == 0;
    }

    public Vector3f cross(@Nonnull Vector2f v) {
        return new Vector3f(0.0f, 0.0f, this.determinant(v));
    }

    public float determinant(@Nonnull Vector2f v) {
        return this.x * v.y - this.y * v.x;
    }

    public static Vector2f interpolate(@Nonnull Vector2f beginVec, @Nonnull Vector2f finalVec, float changeAmnt) {
        return beginVec.interpolate(finalVec, changeAmnt);
    }

    public float smallestAngleBetween(Vector2f otherVector) {
        float dotProduct = this.dot(otherVector);
        float angle = FastMath.acos(dotProduct);
        return angle;
    }

    @Override
    public float angleBetween(Vector2f otherVector) {
        float angle = FastMath.atan2(otherVector.y, otherVector.x) - FastMath.atan2(this.y, this.x);
        return angle;
    }

    public float getAngle() {
        return FastMath.atan2(this.y, this.x);
    }

    @Override
    public float[] toArray() {
        return new float[]{this.x, this.y};
    }

    @Override
    protected Vector2f build(float[] v) {
        return new Vector2f(v[0], v[1]);
    }

    @Override
    protected Vector2f build(float s) {
        return new Vector2f(s);
    }
}

