/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.math;

import java.io.Serializable;
import java.util.logging.Logger;
import org.saintandreas.math.FastMath;
import org.saintandreas.math.Matrix3f;
import org.saintandreas.math.Matrix4f;
import org.saintandreas.math.Vector3f;
import org.saintandreas.math.Vector4;

public final class Quaternion
extends Vector4<Quaternion>
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Quaternion.class.getName());
    public static final Quaternion IDENTITY = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Quaternion DIRECTION_Z = Quaternion.fromAxes(Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z);
    public static final Quaternion ZERO = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);

    public static Quaternion fromMatrix3f(Matrix3f matrix) {
        return Quaternion.fromMatrix3f(matrix.m00, matrix.m01, matrix.m02, matrix.m10, matrix.m11, matrix.m12, matrix.m20, matrix.m21, matrix.m22);
    }

    public static Quaternion fromMatrix3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float z;
        float y;
        float x;
        float w;
        float t = m00 + m11 + m22;
        if (t >= 0.0f) {
            float s = FastMath.sqrt(t + 1.0f);
            w = 0.5f * s;
            s = 0.5f / s;
            x = (m21 - m12) * s;
            y = (m02 - m20) * s;
            z = (m10 - m01) * s;
        } else if (m00 > m11 && m00 > m22) {
            float s = FastMath.sqrt(1.0f + m00 - m11 - m22);
            x = s * 0.5f;
            s = 0.5f / s;
            y = (m10 + m01) * s;
            z = (m02 + m20) * s;
            w = (m21 - m12) * s;
        } else if (m11 > m22) {
            float s = FastMath.sqrt(1.0f + m11 - m00 - m22);
            y = s * 0.5f;
            s = 0.5f / s;
            x = (m10 + m01) * s;
            z = (m21 + m12) * s;
            w = (m02 - m20) * s;
        } else {
            float s = FastMath.sqrt(1.0f + m22 - m00 - m11);
            z = s * 0.5f;
            s = 0.5f / s;
            x = (m02 + m20) * s;
            y = (m21 + m12) * s;
            w = (m10 - m01) * s;
        }
        return new Quaternion(x, y, z, w);
    }

    public Quaternion() {
        super(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion(float x, float y, float z, float w) {
        super(x, y, z, w);
    }

    public boolean isIdentity() {
        return this.equalsEpsilon(IDENTITY, 1.1920929E-7f);
    }

    private Quaternion(QuaternionTemp q) {
        super(q.x, q.y, q.z, q.w);
    }

    public static Quaternion fromAngles(float xAngle, float yAngle, float zAngle) {
        float angle = zAngle * 0.5f;
        float sinZ = FastMath.sin(angle);
        float cosZ = FastMath.cos(angle);
        angle = yAngle * 0.5f;
        float sinY = FastMath.sin(angle);
        float cosY = FastMath.cos(angle);
        angle = xAngle * 0.5f;
        float sinX = FastMath.sin(angle);
        float cosX = FastMath.cos(angle);
        float cosYXcosZ = cosY * cosZ;
        float sinYXsinZ = sinY * sinZ;
        float cosYXsinZ = cosY * sinZ;
        float sinYXcosZ = sinY * cosZ;
        QuaternionTemp temp = new QuaternionTemp();
        temp.w = cosYXcosZ * cosX - sinYXsinZ * sinX;
        temp.x = cosYXcosZ * sinX + sinYXsinZ * cosX;
        temp.y = sinYXcosZ * cosX + cosYXsinZ * sinX;
        temp.z = cosYXsinZ * cosX - sinYXcosZ * sinX;
        return (Quaternion)new Quaternion(temp).normalize();
    }

    public float[] toAngles(float[] angles) {
        if (angles == null) {
            angles = new float[3];
        } else if (angles.length != 3) {
            throw new IllegalArgumentException("Angles array must have three elements");
        }
        float sqw = this.w * this.w;
        float sqx = this.x * this.x;
        float sqy = this.y * this.y;
        float sqz = this.z * this.z;
        float unit = sqx + sqy + sqz + sqw;
        float test = this.x * this.y + this.z * this.w;
        if ((double)test > 0.499 * (double)unit) {
            angles[1] = 2.0f * FastMath.atan2(this.x, this.w);
            angles[2] = 1.5707964f;
            angles[0] = 0.0f;
        } else if ((double)test < -0.499 * (double)unit) {
            angles[1] = -2.0f * FastMath.atan2(this.x, this.w);
            angles[2] = -1.5707964f;
            angles[0] = 0.0f;
        } else {
            angles[1] = FastMath.atan2(2.0f * this.y * this.w - 2.0f * this.x * this.z, sqx - sqy - sqz + sqw);
            angles[2] = FastMath.asin(2.0f * test / unit);
            angles[0] = FastMath.atan2(2.0f * this.x * this.w - 2.0f * this.y * this.z, -sqx + sqy - sqz + sqw);
        }
        return angles;
    }

    public Matrix3f toRotationMatrix() {
        float norm = this.norm();
        float s = norm == 1.0f ? 2.0f : (norm > 0.0f ? 2.0f / norm : 0.0f);
        float xs = this.x * s;
        float ys = this.y * s;
        float zs = this.z * s;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = this.w * xs;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = this.w * ys;
        float zz = this.z * zs;
        float zw = this.w * zs;
        return new Matrix3f(1.0f - (yy + zz), xy - zw, xz + yw, xy + zw, 1.0f - (xx + zz), yz - xw, xz - yw, yz + xw, 1.0f - (xx + yy));
    }

    public Matrix4f toRotationMatrix4f() {
        float norm = this.norm();
        float s = norm == 1.0f ? 2.0f : (norm > 0.0f ? 2.0f / norm : 0.0f);
        float xs = this.x * s;
        float ys = this.y * s;
        float zs = this.z * s;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = this.w * xs;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = this.w * ys;
        float zz = this.z * zs;
        float zw = this.w * zs;
        return new Matrix4f(1.0f - (yy + zz), xy - zw, xz + yw, 0.0f, xy + zw, 1.0f - (xx + zz), yz - xw, 0.0f, xz - yw, yz + xw, 1.0f - (xx + yy), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Vector3f getRotationColumn(int i) {
        float rz;
        float ry;
        float rx;
        float norm = this.norm();
        if (norm != 1.0f) {
            norm = FastMath.invSqrt(norm);
        }
        float xx = this.x * this.x * norm;
        float xy = this.x * this.y * norm;
        float xz = this.x * this.z * norm;
        float xw = this.x * this.w * norm;
        float yy = this.y * this.y * norm;
        float yz = this.y * this.z * norm;
        float yw = this.y * this.w * norm;
        float zz = this.z * this.z * norm;
        float zw = this.z * this.w * norm;
        switch (i) {
            case 0: {
                rx = 1.0f - 2.0f * (yy + zz);
                ry = 2.0f * (xy + zw);
                rz = 2.0f * (xz - yw);
                break;
            }
            case 1: {
                rx = 2.0f * (xy - zw);
                ry = 1.0f - 2.0f * (xx + zz);
                rz = 2.0f * (yz + xw);
                break;
            }
            case 2: {
                rx = 2.0f * (xz + yw);
                ry = 2.0f * (yz - xw);
                rz = 1.0f - 2.0f * (xx + yy);
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new IllegalArgumentException("Invalid column index. " + i);
            }
        }
        return new Vector3f(rx, ry, rz);
    }

    public static Quaternion fromAngleAxis(float angle, Vector3f axis) {
        Vector3f normAxis = (Vector3f)axis.normalize();
        return Quaternion.fromAngleNormalAxis(angle, normAxis);
    }

    public static Quaternion fromAngleNormalAxis(float angle, Vector3f axis) {
        if (axis.x == 0.0f && axis.y == 0.0f && axis.z == 0.0f) {
            return IDENTITY;
        }
        float halfAngle = 0.5f * angle;
        float sin = FastMath.sin(halfAngle);
        return new Quaternion(sin * axis.x, sin * axis.y, sin * axis.z, FastMath.cos(halfAngle));
    }

    public static Quaternion slerp(Quaternion q1, Quaternion q2, float t) {
        return q1.slerp(q2, t);
    }

    public Quaternion slerp(Quaternion q2, float changeAmnt) {
        if (this.x == q2.x && this.y == q2.y && this.z == q2.z && this.w == q2.w) {
            return this;
        }
        float result = this.x * q2.x + this.y * q2.y + this.z * q2.z + this.w * q2.w;
        if (result < 0.0f) {
            q2 = (Quaternion)q2.negate();
            result = -result;
        }
        float scale0 = 1.0f - changeAmnt;
        float scale1 = changeAmnt;
        if (1.0f - result > 0.1f) {
            float theta = FastMath.acos(result);
            float invSinTheta = 1.0f / FastMath.sin(theta);
            scale0 = FastMath.sin((1.0f - changeAmnt) * theta) * invSinTheta;
            scale1 = FastMath.sin(changeAmnt * theta) * invSinTheta;
        }
        return new Quaternion(scale0 * this.x + scale1 * q2.x, scale0 * this.y + scale1 * q2.y, scale0 * this.z + scale1 * q2.z, scale0 * this.w + scale1 * q2.w);
    }

    public Quaternion nlerp(Quaternion q2, float blend) {
        float dot = this.dot(q2);
        float blendI = 1.0f - blend;
        QuaternionTemp q = new QuaternionTemp();
        if (dot < 0.0f) {
            q.x = blendI * this.x - blend * q2.x;
            q.y = blendI * this.y - blend * q2.y;
            q.z = blendI * this.z - blend * q2.z;
            q.w = blendI * this.w - blend * q2.w;
        } else {
            q.x = blendI * this.x + blend * q2.x;
            q.y = blendI * this.y + blend * q2.y;
            q.z = blendI * this.z + blend * q2.z;
            q.w = blendI * this.w + blend * q2.w;
        }
        return (Quaternion)new Quaternion(q).normalize();
    }

    @Override
    public Quaternion mult(Quaternion q) {
        QuaternionTemp res = new QuaternionTemp();
        res.x = this.x * q.w + this.y * q.z - this.z * q.y + this.w * q.x;
        res.y = -this.x * q.z + this.y * q.w + this.z * q.x + this.w * q.y;
        res.z = this.x * q.y - this.y * q.x + this.z * q.w + this.w * q.z;
        res.w = -this.x * q.x - this.y * q.y - this.z * q.z + this.w * q.w;
        return new Quaternion(res);
    }

    public Quaternion apply(Matrix3f matrix) {
        return this.mult(Quaternion.fromMatrix3f(matrix));
    }

    public static Quaternion fromAxes(Vector3f[] axis) {
        return Quaternion.fromAxes(axis[0], axis[1], axis[2]);
    }

    public static Quaternion fromAxes(Vector3f xAxis, Vector3f yAxis, Vector3f zAxis) {
        return Quaternion.fromMatrix3f(new Matrix3f(xAxis.x, yAxis.x, zAxis.x, xAxis.y, yAxis.y, zAxis.y, xAxis.z, yAxis.z, zAxis.z));
    }

    public void toAxes(Vector3f[] axis) {
        Matrix3f tempMat = this.toRotationMatrix();
        axis[0] = tempMat.getColumn(0);
        axis[1] = tempMat.getColumn(1);
        axis[2] = tempMat.getColumn(2);
    }

    @Override
    public Vector3f mult(Vector3f v) {
        float tempX = this.w * this.w * v.x + 2.0f * this.y * this.w * v.z - 2.0f * this.z * this.w * v.y + this.x * this.x * v.x + 2.0f * this.y * this.x * v.y + 2.0f * this.z * this.x * v.z - this.z * this.z * v.x - this.y * this.y * v.x;
        float tempY = 2.0f * this.x * this.y * v.x + this.y * this.y * v.y + 2.0f * this.z * this.y * v.z + 2.0f * this.w * this.z * v.x - this.z * this.z * v.y + this.w * this.w * v.y - 2.0f * this.x * this.w * v.z - this.x * this.x * v.y;
        float tempZ = 2.0f * this.x * this.z * v.x + 2.0f * this.y * this.z * v.y + this.z * this.z * v.z - 2.0f * this.w * this.y * v.x - this.y * this.y * v.z + 2.0f * this.w * this.x * v.y - this.x * this.x * v.z + this.w * this.w * v.z;
        return new Vector3f(tempX, tempY, tempZ);
    }

    public float norm() {
        return this.dot(this);
    }

    @Override
    public Quaternion inverse() {
        float norm = this.norm();
        if ((double)norm > 0.0) {
            float invNorm = 1.0f / norm;
            return new Quaternion(-this.x * invNorm, -this.y * invNorm, -this.z * invNorm, this.w * invNorm);
        }
        return null;
    }

    @Override
    protected Quaternion build(float x, float y, float z, float w) {
        return new Quaternion(x, y, z, w);
    }

    @Override
    protected Quaternion build(float[] v) {
        return new Quaternion(v[0], v[1], v[2], v[3]);
    }

    @Override
    protected Quaternion build(float s) {
        return new Quaternion(s, s, s, s);
    }

    private static class QuaternionTemp {
        float x;
        float y;
        float z;
        float w;

        private QuaternionTemp() {
        }
    }
}

