/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.math;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.saintandreas.math.FastMath;
import org.saintandreas.math.Matrix3f;
import org.saintandreas.math.Quaternion;
import org.saintandreas.math.Vector2f;
import org.saintandreas.math.Vector3f;
import org.saintandreas.math.Vector4f;

public final class Matrix4f
implements Serializable {
    static final long serialVersionUID = 1L;
    public final float m00;
    public final float m01;
    public final float m02;
    public final float m03;
    public final float m10;
    public final float m11;
    public final float m12;
    public final float m13;
    public final float m20;
    public final float m21;
    public final float m22;
    public final float m23;
    public final float m30;
    public final float m31;
    public final float m32;
    public final float m33;
    public static final Matrix4f ZERO = new Matrix4f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix4f IDENTITY = new Matrix4f();

    public Matrix4f() {
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public Matrix4f(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public Matrix4f(float[] array) {
        this(array, false);
    }

    public Matrix4f(float[] matrix, boolean rowMajor) {
        if (matrix.length != 16) {
            throw new IllegalArgumentException("Array must be of size 16.");
        }
        if (rowMajor) {
            this.m00 = matrix[0];
            this.m01 = matrix[1];
            this.m02 = matrix[2];
            this.m03 = matrix[3];
            this.m10 = matrix[4];
            this.m11 = matrix[5];
            this.m12 = matrix[6];
            this.m13 = matrix[7];
            this.m20 = matrix[8];
            this.m21 = matrix[9];
            this.m22 = matrix[10];
            this.m23 = matrix[11];
            this.m30 = matrix[12];
            this.m31 = matrix[13];
            this.m32 = matrix[14];
            this.m33 = matrix[15];
        } else {
            this.m00 = matrix[0];
            this.m01 = matrix[4];
            this.m02 = matrix[8];
            this.m03 = matrix[12];
            this.m10 = matrix[1];
            this.m11 = matrix[5];
            this.m12 = matrix[9];
            this.m13 = matrix[13];
            this.m20 = matrix[2];
            this.m21 = matrix[6];
            this.m22 = matrix[10];
            this.m23 = matrix[14];
            this.m30 = matrix[3];
            this.m31 = matrix[7];
            this.m32 = matrix[11];
            this.m33 = matrix[15];
        }
    }

    public void get(float[] matrix) {
        this.get(matrix, true);
    }

    public void get(float[] matrix, boolean rowMajor) {
        if (matrix.length != 16) {
            throw new IllegalArgumentException("Array must be of size 16.");
        }
        if (rowMajor) {
            matrix[0] = this.m00;
            matrix[1] = this.m01;
            matrix[2] = this.m02;
            matrix[3] = this.m03;
            matrix[4] = this.m10;
            matrix[5] = this.m11;
            matrix[6] = this.m12;
            matrix[7] = this.m13;
            matrix[8] = this.m20;
            matrix[9] = this.m21;
            matrix[10] = this.m22;
            matrix[11] = this.m23;
            matrix[12] = this.m30;
            matrix[13] = this.m31;
            matrix[14] = this.m32;
            matrix[15] = this.m33;
        } else {
            matrix[0] = this.m00;
            matrix[4] = this.m01;
            matrix[8] = this.m02;
            matrix[12] = this.m03;
            matrix[1] = this.m10;
            matrix[5] = this.m11;
            matrix[9] = this.m12;
            matrix[13] = this.m13;
            matrix[2] = this.m20;
            matrix[6] = this.m21;
            matrix[10] = this.m22;
            matrix[14] = this.m23;
            matrix[3] = this.m30;
            matrix[7] = this.m31;
            matrix[11] = this.m32;
            matrix[15] = this.m33;
        }
    }

    public float get(int i, int j) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                }
            }
            case 1: {
                switch (j) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                }
            }
            case 2: {
                switch (j) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                }
            }
            case 3: {
                switch (j) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public float[] getColumn(int i) {
        return this.getColumn(i, null);
    }

    public float[] getColumn(int i, float[] store) {
        if (store == null) {
            store = new float[4];
        }
        switch (i) {
            case 0: {
                store[0] = this.m00;
                store[1] = this.m10;
                store[2] = this.m20;
                store[3] = this.m30;
                break;
            }
            case 1: {
                store[0] = this.m01;
                store[1] = this.m11;
                store[2] = this.m21;
                store[3] = this.m31;
                break;
            }
            case 2: {
                store[0] = this.m02;
                store[1] = this.m12;
                store[2] = this.m22;
                store[3] = this.m32;
                break;
            }
            case 3: {
                store[0] = this.m03;
                store[1] = this.m13;
                store[2] = this.m23;
                store[3] = this.m33;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index. " + i);
            }
        }
        return store;
    }

    public Matrix4f(float[][] matrix) {
        if (matrix.length != 4 || matrix[0].length != 4) {
            throw new IllegalArgumentException("Array must be of size 16.");
        }
        this.m00 = matrix[0][0];
        this.m01 = matrix[0][1];
        this.m02 = matrix[0][2];
        this.m03 = matrix[0][3];
        this.m10 = matrix[1][0];
        this.m11 = matrix[1][1];
        this.m12 = matrix[1][2];
        this.m13 = matrix[1][3];
        this.m20 = matrix[2][0];
        this.m21 = matrix[2][1];
        this.m22 = matrix[2][2];
        this.m23 = matrix[2][3];
        this.m30 = matrix[3][0];
        this.m31 = matrix[3][1];
        this.m32 = matrix[3][2];
        this.m33 = matrix[3][3];
    }

    public Matrix4f transpose() {
        float[] tmp = new float[16];
        this.get(tmp, true);
        Matrix4f mat = new Matrix4f(tmp);
        return mat;
    }

    public FloatBuffer toFloatBuffer() {
        return this.toFloatBuffer(false);
    }

    public FloatBuffer toFloatBuffer(boolean columnMajor) {
        FloatBuffer fb = ByteBuffer.allocateDirect(64).asFloatBuffer();
        this.fillFloatBuffer(fb, columnMajor);
        fb.rewind();
        return fb;
    }

    public void fillFloatBuffer(FloatBuffer fb) {
        this.fillFloatBuffer(fb, false);
    }

    public void fillFloatBuffer(FloatBuffer fb, boolean columnMajor) {
        if (columnMajor) {
            fb.put(this.m00).put(this.m10).put(this.m20).put(this.m30);
            fb.put(this.m01).put(this.m11).put(this.m21).put(this.m31);
            fb.put(this.m02).put(this.m12).put(this.m22).put(this.m32);
            fb.put(this.m03).put(this.m13).put(this.m23).put(this.m33);
        } else {
            fb.put(this.m00).put(this.m01).put(this.m02).put(this.m03);
            fb.put(this.m10).put(this.m11).put(this.m12).put(this.m13);
            fb.put(this.m20).put(this.m21).put(this.m22).put(this.m23);
            fb.put(this.m30).put(this.m31).put(this.m32).put(this.m33);
        }
    }

    public void fillFloatArray(float[] f) {
        this.fillFloatArray(f, false);
    }

    public void fillFloatArray(float[] f, boolean columnMajor) {
        if (columnMajor) {
            f[0] = this.m00;
            f[1] = this.m10;
            f[2] = this.m20;
            f[3] = this.m30;
            f[4] = this.m01;
            f[5] = this.m11;
            f[6] = this.m21;
            f[7] = this.m31;
            f[8] = this.m02;
            f[9] = this.m12;
            f[10] = this.m22;
            f[11] = this.m32;
            f[12] = this.m03;
            f[13] = this.m13;
            f[14] = this.m23;
            f[15] = this.m33;
        } else {
            f[0] = this.m00;
            f[1] = this.m01;
            f[2] = this.m02;
            f[3] = this.m03;
            f[4] = this.m10;
            f[5] = this.m11;
            f[6] = this.m12;
            f[7] = this.m13;
            f[8] = this.m20;
            f[9] = this.m21;
            f[10] = this.m22;
            f[11] = this.m23;
            f[12] = this.m30;
            f[13] = this.m31;
            f[14] = this.m32;
            f[15] = this.m33;
        }
    }

    public Matrix4f(FloatBuffer fb) {
        this(fb, false);
    }

    public Matrix4f(FloatBuffer fb, boolean columnMajor) {
        if (columnMajor) {
            this.m00 = fb.get();
            this.m10 = fb.get();
            this.m20 = fb.get();
            this.m30 = fb.get();
            this.m01 = fb.get();
            this.m11 = fb.get();
            this.m21 = fb.get();
            this.m31 = fb.get();
            this.m02 = fb.get();
            this.m12 = fb.get();
            this.m22 = fb.get();
            this.m32 = fb.get();
            this.m03 = fb.get();
            this.m13 = fb.get();
            this.m23 = fb.get();
            this.m33 = fb.get();
        } else {
            this.m00 = fb.get();
            this.m01 = fb.get();
            this.m02 = fb.get();
            this.m03 = fb.get();
            this.m10 = fb.get();
            this.m11 = fb.get();
            this.m12 = fb.get();
            this.m13 = fb.get();
            this.m20 = fb.get();
            this.m21 = fb.get();
            this.m22 = fb.get();
            this.m23 = fb.get();
            this.m30 = fb.get();
            this.m31 = fb.get();
            this.m32 = fb.get();
            this.m33 = fb.get();
        }
    }

    private Matrix4f(Matrix4fTemp m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.m30 = m.m30;
        this.m31 = m.m31;
        this.m32 = m.m32;
        this.m33 = m.m33;
    }

    public static Matrix4f fromFrustum(float near, float far, float left, float right, float top, float bottom, boolean parallel) {
        Matrix4fTemp m = new Matrix4fTemp();
        if (parallel) {
            m.m00 = 2.0f / (right - left);
            m.m11 = 2.0f / (top - bottom);
            m.m22 = -2.0f / (far - near);
            m.m33 = 1.0f;
            m.m03 = -(right + left) / (right - left);
            m.m13 = -(top + bottom) / (top - bottom);
            m.m23 = -(far + near) / (far - near);
        } else {
            m.m00 = 2.0f * near / (right - left);
            m.m11 = 2.0f * near / (top - bottom);
            m.m32 = -1.0f;
            m.m33 = -0.0f;
            m.m02 = (right + left) / (right - left);
            m.m12 = (top + bottom) / (top - bottom);
            m.m22 = -(far + near) / (far - near);
            m.m23 = -(2.0f * far * near) / (far - near);
        }
        return new Matrix4f(m);
    }

    public static Matrix4f fromAngleAxis(float angle, Vector3f axis) {
        Vector3f normAxis = (Vector3f)axis.normalize();
        return Matrix4f.fromAngleNormalAxis(angle, normAxis);
    }

    public static Matrix4f fromAngleNormalAxis(float angle, Vector3f axis) {
        Matrix4fTemp m = new Matrix4fTemp();
        float fCos = FastMath.cos(angle);
        float fSin = FastMath.sin(angle);
        float fOneMinusCos = 1.0f - fCos;
        float fX2 = axis.x * axis.x;
        float fY2 = axis.y * axis.y;
        float fZ2 = axis.z * axis.z;
        float fXYM = axis.x * axis.y * fOneMinusCos;
        float fXZM = axis.x * axis.z * fOneMinusCos;
        float fYZM = axis.y * axis.z * fOneMinusCos;
        float fXSin = axis.x * fSin;
        float fYSin = axis.y * fSin;
        float fZSin = axis.z * fSin;
        m.m00 = fX2 * fOneMinusCos + fCos;
        m.m01 = fXYM - fZSin;
        m.m02 = fXZM + fYSin;
        m.m10 = fXYM + fZSin;
        m.m11 = fY2 * fOneMinusCos + fCos;
        m.m12 = fYZM - fXSin;
        m.m20 = fXZM - fYSin;
        m.m21 = fYZM + fXSin;
        m.m22 = fZ2 * fOneMinusCos + fCos;
        return new Matrix4f(m);
    }

    public void multLocal(float scalar) {
    }

    public Matrix4f mult(float scalar) {
        return new Matrix4f(this.m00 * scalar, this.m01 * scalar, this.m02 * scalar, this.m03 * scalar, this.m10 * scalar, this.m11 * scalar, this.m12 * scalar, this.m13 * scalar, this.m20 * scalar, this.m21 * scalar, this.m22 * scalar, this.m23 * scalar, this.m30 * scalar, this.m31 * scalar, this.m32 * scalar, this.m33 * scalar);
    }

    public Matrix4f mult(Matrix4f in2) {
        Matrix4fTemp store = new Matrix4fTemp();
        float temp00 = this.m00 * in2.m00 + this.m01 * in2.m10 + this.m02 * in2.m20 + this.m03 * in2.m30;
        float temp01 = this.m00 * in2.m01 + this.m01 * in2.m11 + this.m02 * in2.m21 + this.m03 * in2.m31;
        float temp02 = this.m00 * in2.m02 + this.m01 * in2.m12 + this.m02 * in2.m22 + this.m03 * in2.m32;
        float temp03 = this.m00 * in2.m03 + this.m01 * in2.m13 + this.m02 * in2.m23 + this.m03 * in2.m33;
        float temp10 = this.m10 * in2.m00 + this.m11 * in2.m10 + this.m12 * in2.m20 + this.m13 * in2.m30;
        float temp11 = this.m10 * in2.m01 + this.m11 * in2.m11 + this.m12 * in2.m21 + this.m13 * in2.m31;
        float temp12 = this.m10 * in2.m02 + this.m11 * in2.m12 + this.m12 * in2.m22 + this.m13 * in2.m32;
        float temp13 = this.m10 * in2.m03 + this.m11 * in2.m13 + this.m12 * in2.m23 + this.m13 * in2.m33;
        float temp20 = this.m20 * in2.m00 + this.m21 * in2.m10 + this.m22 * in2.m20 + this.m23 * in2.m30;
        float temp21 = this.m20 * in2.m01 + this.m21 * in2.m11 + this.m22 * in2.m21 + this.m23 * in2.m31;
        float temp22 = this.m20 * in2.m02 + this.m21 * in2.m12 + this.m22 * in2.m22 + this.m23 * in2.m32;
        float temp23 = this.m20 * in2.m03 + this.m21 * in2.m13 + this.m22 * in2.m23 + this.m23 * in2.m33;
        float temp30 = this.m30 * in2.m00 + this.m31 * in2.m10 + this.m32 * in2.m20 + this.m33 * in2.m30;
        float temp31 = this.m30 * in2.m01 + this.m31 * in2.m11 + this.m32 * in2.m21 + this.m33 * in2.m31;
        float temp32 = this.m30 * in2.m02 + this.m31 * in2.m12 + this.m32 * in2.m22 + this.m33 * in2.m32;
        float temp33 = this.m30 * in2.m03 + this.m31 * in2.m13 + this.m32 * in2.m23 + this.m33 * in2.m33;
        store.m00 = temp00;
        store.m01 = temp01;
        store.m02 = temp02;
        store.m03 = temp03;
        store.m10 = temp10;
        store.m11 = temp11;
        store.m12 = temp12;
        store.m13 = temp13;
        store.m20 = temp20;
        store.m21 = temp21;
        store.m22 = temp22;
        store.m23 = temp23;
        store.m30 = temp30;
        store.m31 = temp31;
        store.m32 = temp32;
        store.m33 = temp33;
        return new Matrix4f(store);
    }

    public Vector3f mult(Vector3f v) {
        Vector4f result = this.mult(new Vector4f(v, 1.0f));
        return new Vector3f(result.x, result.y, result.z);
    }

    public Vector4f mult(Vector4f v) {
        return new Vector4f(this.m00 * v.x + this.m01 * v.y + this.m02 * v.z + this.m03 * v.w, this.m10 * v.x + this.m11 * v.y + this.m12 * v.z + this.m13 * v.w, this.m20 * v.x + this.m21 * v.y + this.m22 * v.z + this.m23 * v.w, this.m30 * v.x + this.m31 * v.y + this.m32 * v.z + this.m33 * v.w);
    }

    public Vector4f multAcross(Vector4f vec) {
        float vx = vec.x;
        float vy = vec.y;
        float vz = vec.z;
        float vw = vec.w;
        return new Vector4f(this.m00 * vx + this.m10 * vy + this.m20 * vz + this.m30 * vw, this.m01 * vx + this.m11 * vy + this.m21 * vz + this.m31 * vw, this.m02 * vx + this.m12 * vy + this.m22 * vz + this.m32 * vw, this.m03 * vx + this.m13 * vy + this.m23 * vz + this.m33 * vw);
    }

    public Vector3f multNormal(Vector3f vec) {
        float vx = vec.x;
        float vy = vec.y;
        float vz = vec.z;
        return new Vector3f(this.m00 * vx + this.m01 * vy + this.m02 * vz, this.m10 * vx + this.m11 * vy + this.m12 * vz, this.m20 * vx + this.m21 * vy + this.m22 * vz);
    }

    public Vector3f multNormalAcross(Vector3f vec) {
        float vx = vec.x;
        float vy = vec.y;
        float vz = vec.z;
        return new Vector3f(this.m00 * vx + this.m10 * vy + this.m20 * vz, this.m01 * vx + this.m11 * vy + this.m21 * vz, this.m02 * vx + this.m12 * vy + this.m22 * vz);
    }

    public Matrix4f invert() {
        Matrix4fTemp store = new Matrix4fTemp();
        float fA0 = this.m00 * this.m11 - this.m01 * this.m10;
        float fB5 = this.m22 * this.m33 - this.m23 * this.m32;
        float fA1 = this.m00 * this.m12 - this.m02 * this.m10;
        float fB4 = this.m21 * this.m33 - this.m23 * this.m31;
        float fA2 = this.m00 * this.m13 - this.m03 * this.m10;
        float fB3 = this.m21 * this.m32 - this.m22 * this.m31;
        float fA3 = this.m01 * this.m12 - this.m02 * this.m11;
        float fB2 = this.m20 * this.m33 - this.m23 * this.m30;
        float fA4 = this.m01 * this.m13 - this.m03 * this.m11;
        float fB1 = this.m20 * this.m32 - this.m22 * this.m30;
        float fA5 = this.m02 * this.m13 - this.m03 * this.m12;
        float fB0 = this.m20 * this.m31 - this.m21 * this.m30;
        float fDet = fA0 * fB5 - fA1 * fB4 + fA2 * fB3 + fA3 * fB2 - fA4 * fB1 + fA5 * fB0;
        if (FastMath.abs(fDet) <= 0.0f) {
            throw new ArithmeticException("This matrix cannot be inverted");
        }
        store.m00 = this.m11 * fB5 - this.m12 * fB4 + this.m13 * fB3;
        store.m10 = -this.m10 * fB5 + this.m12 * fB2 - this.m13 * fB1;
        store.m20 = this.m10 * fB4 - this.m11 * fB2 + this.m13 * fB0;
        store.m30 = -this.m10 * fB3 + this.m11 * fB1 - this.m12 * fB0;
        store.m01 = -this.m01 * fB5 + this.m02 * fB4 - this.m03 * fB3;
        store.m11 = this.m00 * fB5 - this.m02 * fB2 + this.m03 * fB1;
        store.m21 = -this.m00 * fB4 + this.m01 * fB2 - this.m03 * fB0;
        store.m31 = this.m00 * fB3 - this.m01 * fB1 + this.m02 * fB0;
        store.m02 = this.m31 * fA5 - this.m32 * fA4 + this.m33 * fA3;
        store.m12 = -this.m30 * fA5 + this.m32 * fA2 - this.m33 * fA1;
        store.m22 = this.m30 * fA4 - this.m31 * fA2 + this.m33 * fA0;
        store.m32 = -this.m30 * fA3 + this.m31 * fA1 - this.m32 * fA0;
        store.m03 = -this.m21 * fA5 + this.m22 * fA4 - this.m23 * fA3;
        store.m13 = this.m20 * fA5 - this.m22 * fA2 + this.m23 * fA1;
        store.m23 = -this.m20 * fA4 + this.m21 * fA2 - this.m23 * fA0;
        store.m33 = this.m20 * fA3 - this.m21 * fA1 + this.m22 * fA0;
        return new Matrix4f(store).mult(1.0f / fDet);
    }

    public Matrix4f adjoint() {
        Matrix4fTemp store = new Matrix4fTemp();
        float fA0 = this.m00 * this.m11 - this.m01 * this.m10;
        float fA1 = this.m00 * this.m12 - this.m02 * this.m10;
        float fA2 = this.m00 * this.m13 - this.m03 * this.m10;
        float fA3 = this.m01 * this.m12 - this.m02 * this.m11;
        float fA4 = this.m01 * this.m13 - this.m03 * this.m11;
        float fA5 = this.m02 * this.m13 - this.m03 * this.m12;
        float fB0 = this.m20 * this.m31 - this.m21 * this.m30;
        float fB1 = this.m20 * this.m32 - this.m22 * this.m30;
        float fB2 = this.m20 * this.m33 - this.m23 * this.m30;
        float fB3 = this.m21 * this.m32 - this.m22 * this.m31;
        float fB4 = this.m21 * this.m33 - this.m23 * this.m31;
        float fB5 = this.m22 * this.m33 - this.m23 * this.m32;
        store.m00 = this.m11 * fB5 - this.m12 * fB4 + this.m13 * fB3;
        store.m10 = -this.m10 * fB5 + this.m12 * fB2 - this.m13 * fB1;
        store.m20 = this.m10 * fB4 - this.m11 * fB2 + this.m13 * fB0;
        store.m30 = -this.m10 * fB3 + this.m11 * fB1 - this.m12 * fB0;
        store.m01 = -this.m01 * fB5 + this.m02 * fB4 - this.m03 * fB3;
        store.m11 = this.m00 * fB5 - this.m02 * fB2 + this.m03 * fB1;
        store.m21 = -this.m00 * fB4 + this.m01 * fB2 - this.m03 * fB0;
        store.m31 = this.m00 * fB3 - this.m01 * fB1 + this.m02 * fB0;
        store.m02 = this.m31 * fA5 - this.m32 * fA4 + this.m33 * fA3;
        store.m12 = -this.m30 * fA5 + this.m32 * fA2 - this.m33 * fA1;
        store.m22 = this.m30 * fA4 - this.m31 * fA2 + this.m33 * fA0;
        store.m32 = -this.m30 * fA3 + this.m31 * fA1 - this.m32 * fA0;
        store.m03 = -this.m21 * fA5 + this.m22 * fA4 - this.m23 * fA3;
        store.m13 = this.m20 * fA5 - this.m22 * fA2 + this.m23 * fA1;
        store.m23 = -this.m20 * fA4 + this.m21 * fA2 - this.m23 * fA0;
        store.m33 = this.m20 * fA3 - this.m21 * fA1 + this.m22 * fA0;
        return new Matrix4f(store);
    }

    public float determinant() {
        float fA0 = this.m00 * this.m11 - this.m01 * this.m10;
        float fA1 = this.m00 * this.m12 - this.m02 * this.m10;
        float fA2 = this.m00 * this.m13 - this.m03 * this.m10;
        float fA3 = this.m01 * this.m12 - this.m02 * this.m11;
        float fA4 = this.m01 * this.m13 - this.m03 * this.m11;
        float fA5 = this.m02 * this.m13 - this.m03 * this.m12;
        float fB0 = this.m20 * this.m31 - this.m21 * this.m30;
        float fB1 = this.m20 * this.m32 - this.m22 * this.m30;
        float fB2 = this.m20 * this.m33 - this.m23 * this.m30;
        float fB3 = this.m21 * this.m32 - this.m22 * this.m31;
        float fB4 = this.m21 * this.m33 - this.m23 * this.m31;
        float fB5 = this.m22 * this.m33 - this.m23 * this.m32;
        float fDet = fA0 * fB5 - fA1 * fB4 + fA2 * fB3 + fA3 * fB2 - fA4 * fB1 + fA5 * fB0;
        return fDet;
    }

    public Matrix4f add(Matrix4f mat) {
        Matrix4fTemp result = new Matrix4fTemp();
        result.m00 = this.m00 + mat.m00;
        result.m01 = this.m01 + mat.m01;
        result.m02 = this.m02 + mat.m02;
        result.m03 = this.m03 + mat.m03;
        result.m10 = this.m10 + mat.m10;
        result.m11 = this.m11 + mat.m11;
        result.m12 = this.m12 + mat.m12;
        result.m13 = this.m13 + mat.m13;
        result.m20 = this.m20 + mat.m20;
        result.m21 = this.m21 + mat.m21;
        result.m22 = this.m22 + mat.m22;
        result.m23 = this.m23 + mat.m23;
        result.m30 = this.m30 + mat.m30;
        result.m31 = this.m31 + mat.m31;
        result.m32 = this.m32 + mat.m32;
        result.m33 = this.m33 + mat.m33;
        return new Matrix4f(result);
    }

    public Vector3f toTranslationVector() {
        return new Vector3f(this.m03, this.m13, this.m23);
    }

    public Quaternion toRotationQuat() {
        return Quaternion.fromMatrix3f(this.toRotationMatrix());
    }

    public Matrix3f toRotationMatrix() {
        return new Matrix3f(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + Float.floatToIntBits(this.m00);
        hash = 37 * hash + Float.floatToIntBits(this.m01);
        hash = 37 * hash + Float.floatToIntBits(this.m02);
        hash = 37 * hash + Float.floatToIntBits(this.m03);
        hash = 37 * hash + Float.floatToIntBits(this.m10);
        hash = 37 * hash + Float.floatToIntBits(this.m11);
        hash = 37 * hash + Float.floatToIntBits(this.m12);
        hash = 37 * hash + Float.floatToIntBits(this.m13);
        hash = 37 * hash + Float.floatToIntBits(this.m20);
        hash = 37 * hash + Float.floatToIntBits(this.m21);
        hash = 37 * hash + Float.floatToIntBits(this.m22);
        hash = 37 * hash + Float.floatToIntBits(this.m23);
        hash = 37 * hash + Float.floatToIntBits(this.m30);
        hash = 37 * hash + Float.floatToIntBits(this.m31);
        hash = 37 * hash + Float.floatToIntBits(this.m32);
        hash = 37 * hash + Float.floatToIntBits(this.m33);
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix4f) || o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Matrix4f comp = (Matrix4f)o;
        if (Float.compare(this.m00, comp.m00) != 0) {
            return false;
        }
        if (Float.compare(this.m01, comp.m01) != 0) {
            return false;
        }
        if (Float.compare(this.m02, comp.m02) != 0) {
            return false;
        }
        if (Float.compare(this.m03, comp.m03) != 0) {
            return false;
        }
        if (Float.compare(this.m10, comp.m10) != 0) {
            return false;
        }
        if (Float.compare(this.m11, comp.m11) != 0) {
            return false;
        }
        if (Float.compare(this.m12, comp.m12) != 0) {
            return false;
        }
        if (Float.compare(this.m13, comp.m13) != 0) {
            return false;
        }
        if (Float.compare(this.m20, comp.m20) != 0) {
            return false;
        }
        if (Float.compare(this.m21, comp.m21) != 0) {
            return false;
        }
        if (Float.compare(this.m22, comp.m22) != 0) {
            return false;
        }
        if (Float.compare(this.m23, comp.m23) != 0) {
            return false;
        }
        if (Float.compare(this.m30, comp.m30) != 0) {
            return false;
        }
        if (Float.compare(this.m31, comp.m31) != 0) {
            return false;
        }
        if (Float.compare(this.m32, comp.m32) != 0) {
            return false;
        }
        return Float.compare(this.m33, comp.m33) == 0;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m03 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m13 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f && this.m23 == 0.0f && this.m30 == 0.0f && this.m31 == 0.0f && this.m32 == 0.0f && this.m33 == 1.0f;
    }

    static boolean equalIdentity(Matrix4f mat) {
        if ((double)Math.abs(mat.m00 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m11 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m22 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m33 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m03) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m13) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m20) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m21) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m23) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m30) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m31) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(mat.m32) > 1.0E-4);
    }

    public static Matrix4f translation(Vector2f v) {
        return Matrix4f.translation(new Vector3f(v, 0.0f));
    }

    public static Matrix4f translation(Vector3f v) {
        Matrix4fTemp m = new Matrix4fTemp();
        m.m03 = v.x;
        m.m13 = v.y;
        m.m23 = v.z;
        return new Matrix4f(m);
    }

    public static Matrix4f rotation(Quaternion q) {
        return q.toRotationMatrix4f();
    }

    public static Matrix4f rotation(Matrix3f m) {
        return Quaternion.fromMatrix3f(m).toRotationMatrix4f();
    }

    public static Matrix4f rotation(float angle, Vector3f axis) {
        return Matrix4f.rotation(Quaternion.fromAngleAxis(angle, axis));
    }

    public static Matrix4f scaled(float f) {
        return Matrix4f.scaled(new Vector3f(f, f, f));
    }

    public static Matrix4f scaled(Vector3f v) {
        Matrix4fTemp m = new Matrix4fTemp();
        m.m00 *= v.x;
        m.m11 *= v.y;
        m.m22 *= v.z;
        return new Matrix4f(m);
    }

    public Matrix4f translate(Vector2f v) {
        return this.mult(Matrix4f.translation(v));
    }

    public Matrix4f translate(Vector3f v) {
        return this.mult(Matrix4f.translation(v));
    }

    public Matrix4f rotate(Quaternion q) {
        return this.mult(Matrix4f.rotation(q));
    }

    public Matrix4f rotate(float angle, Vector3f axis) {
        return this.mult(Matrix4f.rotation(angle, axis));
    }

    public Matrix4f rotate(Matrix3f m) {
        return this.mult(Matrix4f.rotation(m));
    }

    public Matrix4f scale(float f) {
        return this.mult(Matrix4f.scaled(f));
    }

    public Matrix4f scale(Vector3f v) {
        return this.mult(Matrix4f.scaled(v));
    }

    public static Matrix4f orthographic(float left, float right, float bottom, float top, float near, float far) {
        float x_orth = 2.0f / (right - left);
        float y_orth = 2.0f / (top - bottom);
        float z_orth = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        Matrix4fTemp m = new Matrix4fTemp();
        m.m00 = x_orth;
        m.m10 = 0.0f;
        m.m20 = 0.0f;
        m.m30 = 0.0f;
        m.m01 = 0.0f;
        m.m11 = y_orth;
        m.m21 = 0.0f;
        m.m31 = 0.0f;
        m.m02 = 0.0f;
        m.m12 = 0.0f;
        m.m22 = z_orth;
        m.m32 = 0.0f;
        m.m03 = tx;
        m.m13 = ty;
        m.m23 = tz;
        m.m33 = 1.0f;
        return new Matrix4f(m);
    }

    public static Matrix4f lookat(Vector3f eye, Vector3f center, Vector3f up) {
        Vector3f f = (Vector3f)center.subtract(eye).normalize();
        Vector3f s = (Vector3f)f.cross(up).normalize();
        Vector3f u = s.cross(f);
        Matrix4fTemp m = new Matrix4fTemp();
        m.m00 = s.x;
        m.m01 = s.y;
        m.m02 = s.z;
        m.m10 = u.x;
        m.m11 = u.y;
        m.m12 = u.z;
        m.m20 = -f.x;
        m.m21 = -f.y;
        m.m22 = -f.z;
        m.m03 = -s.dot(eye);
        m.m13 = -u.dot(eye);
        m.m23 = f.dot(eye);
        return new Matrix4f(m);
    }

    public static Matrix4f perspective(float fovy, float aspect, float zNear, float zFar) {
        float ymax = (float)((double)zNear * Math.tan((double)fovy * Math.PI / 360.0));
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        return Matrix4f.fromFrustum(zNear, zFar, xmin, xmax, ymax, ymin, false);
    }

    private static class Matrix4fTemp {
        public float m00 = 1.0f;
        public float m01 = 0.0f;
        public float m02 = 0.0f;
        public float m03 = 0.0f;
        public float m10 = 0.0f;
        public float m11 = 1.0f;
        public float m12 = 0.0f;
        public float m13 = 0.0f;
        public float m20 = 0.0f;
        public float m21 = 0.0f;
        public float m22 = 1.0f;
        public float m23 = 0.0f;
        public float m30 = 0.0f;
        public float m31 = 0.0f;
        public float m32 = 0.0f;
        public float m33 = 1.0f;
    }
}

