/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.gpio.extension.base.AdcGpioProviderBase;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.spi.SpiChannel;
import com.pi4j.io.spi.SpiDevice;
import com.pi4j.io.spi.SpiFactory;
import com.pi4j.io.spi.SpiMode;
import java.io.IOException;

public abstract class MCP3x0xGpioProvider
extends AdcGpioProviderBase
implements GpioProvider {
    public final int MAX_VALUE;
    public final int MIN_VALUE = 0;
    public final int RESOLUTION;
    private final SpiDevice device;

    public MCP3x0xGpioProvider(Pin[] pins, SpiChannel channel, int speed, int resolution, SpiMode mode) throws IOException {
        super(pins);
        this.device = SpiFactory.getInstance((SpiChannel)channel, (int)speed, (SpiMode)mode);
        this.RESOLUTION = resolution;
        this.MAX_VALUE = (1 << resolution) - 1;
    }

    @Override
    public double getImmediateValue(Pin pin) throws IOException {
        double value;
        if (this.isInitiated() && (value = (double)this.readAnalog(this.toCommand((short)pin.getAddress()))) >= 0.0 && value <= (double)this.MAX_VALUE) {
            this.getPinCache(pin).setAnalogValue(value);
            return value;
        }
        return -1.0;
    }

    @Override
    public double getMinSupportedValue() {
        return 0.0;
    }

    @Override
    public double getMaxSupportedValue() {
        return this.MAX_VALUE;
    }

    private short toCommand(short channel) {
        short command = (short)(channel + 8 << 4);
        return command;
    }

    private boolean isInitiated() {
        return this.device != null;
    }

    private synchronized int readAnalog(short channelCommand) {
        short[] result;
        short[] sArray;
        if (this.RESOLUTION > 10) {
            short[] sArray2 = new short[4];
            sArray2[0] = 1;
            sArray2[1] = channelCommand;
            sArray2[2] = 0;
            sArray = sArray2;
            sArray2[3] = 0;
        } else {
            short[] sArray3 = new short[3];
            sArray3[0] = 1;
            sArray3[1] = channelCommand;
            sArray = sArray3;
            sArray3[2] = 0;
        }
        short[] data = sArray;
        try {
            result = this.device.write(data);
        }
        catch (IOException e) {
            return -1;
        }
        int analogValue = ((result[1] & 3) << this.RESOLUTION - 2) + (result[2] << this.RESOLUTION - 10);
        if (this.RESOLUTION > 10) {
            analogValue += result[3];
        }
        return analogValue;
    }
}

