/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.base;

import com.pi4j.gpio.extension.base.AdcGpioProvider;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.event.PinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinListener;
import java.io.IOException;
import java.util.List;

public abstract class AdcGpioProviderBase
extends GpioProviderBase
implements AdcGpioProvider {
    protected ADCMonitor monitor = null;
    protected int conversionDelay = 0;
    protected int monitorInterval = 100;
    protected Pin[] allPins = null;
    protected double[] threshold = null;

    public AdcGpioProviderBase(Pin[] pins) {
        this.allPins = pins;
        for (double item : this.threshold = new double[pins.length]) {
            item = 5.0;
        }
    }

    public double getValue(Pin pin) {
        if (this.monitor == null) {
            super.getValue(pin);
            try {
                return this.getImmediateValue(pin);
            }
            catch (IOException e) {
                return -1.0;
            }
        }
        return super.getValue(pin);
    }

    @Override
    public float getPercentValue(Pin pin) {
        double value = this.getValue(pin);
        if (value > -1.0) {
            return (float)(value / (this.getMaxSupportedValue() - this.getMinSupportedValue())) * 100.0f;
        }
        return -1.0f;
    }

    @Override
    public float getPercentValue(GpioPinAnalogInput pin) {
        return this.getPercentValue(pin.getPin());
    }

    @Override
    public double getImmediateValue(GpioPinAnalogInput pin) throws IOException {
        return this.getImmediateValue(pin.getPin());
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            if (this.monitor != null) {
                this.monitor.shutdown();
                this.monitor = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getEventThreshold(Pin pin) {
        return this.threshold[pin.getAddress()];
    }

    @Override
    public double getEventThreshold(GpioPinAnalogInput pin) {
        return this.getEventThreshold(pin.getPin());
    }

    @Override
    public void setEventThreshold(double threshold, Pin ... pin) {
        for (Pin p : pin) {
            this.threshold[p.getAddress()] = threshold;
        }
    }

    @Override
    public void setEventThreshold(double threshold, GpioPinAnalogInput ... pin) {
        for (GpioPinAnalogInput p : pin) {
            this.setEventThreshold(threshold, p.getPin());
        }
    }

    @Override
    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    @Override
    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
        if (monitorInterval < 1) {
            monitorInterval = 250;
        }
    }

    @Override
    public boolean getMonitorEnabled() {
        return this.monitor != null;
    }

    @Override
    public void setMonitorEnabled(boolean enabled) {
        if (enabled) {
            if (this.monitor == null) {
                this.monitor = new ADCMonitor();
                this.monitor.start();
            }
        } else {
            try {
                if (this.monitor != null) {
                    this.monitor.shutdown();
                    this.monitor = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public abstract double getImmediateValue(Pin var1) throws IOException;

    private class ADCMonitor
    extends Thread {
        private boolean shuttingDown = false;

        private ADCMonitor() {
        }

        public void shutdown() {
            this.shuttingDown = true;
        }

        @Override
        public void run() {
            while (!this.shuttingDown) {
                try {
                    if (AdcGpioProviderBase.this.allPins != null && AdcGpioProviderBase.this.allPins.length > 0) {
                        for (Pin pin : AdcGpioProviderBase.this.allPins) {
                            try {
                                double oldValue = AdcGpioProviderBase.this.getPinCache(pin).getAnalogValue();
                                double newValue = AdcGpioProviderBase.this.getImmediateValue(pin);
                                if (newValue <= -1.0) break;
                                if (AdcGpioProviderBase.this.threshold == null || Math.abs(oldValue - newValue) > AdcGpioProviderBase.this.threshold[pin.getAddress()]) {
                                    AdcGpioProviderBase.this.getPinCache(pin).setAnalogValue(newValue);
                                    if (AdcGpioProviderBase.this.getMode(pin) == PinMode.ANALOG_INPUT) {
                                        this.dispatchPinChangeEvent(pin.getAddress(), newValue);
                                    }
                                }
                                try {
                                    if (AdcGpioProviderBase.this.conversionDelay <= 0) continue;
                                    Thread.sleep(AdcGpioProviderBase.this.conversionDelay);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(AdcGpioProviderBase.this.monitorInterval);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void dispatchPinChangeEvent(int pinAddress, double value) {
            for (Pin pin : AdcGpioProviderBase.this.listeners.keySet()) {
                if (pin.getAddress() != pinAddress) continue;
                for (PinListener listener : (List)AdcGpioProviderBase.this.listeners.get(pin)) {
                    listener.handlePinEvent((PinEvent)new PinAnalogValueChangeEvent((Object)this, pin, value));
                }
            }
        }
    }
}

