/*
 * Decompiled with CFR 0.152.
 */
package org.staccato.functions;

import org.jfugue.provider.NoteProviderFactory;
import org.jfugue.theory.Note;
import org.staccato.PreprocessorFunction;
import org.staccato.StaccatoParserContext;

public class TrillFunction
implements PreprocessorFunction {
    private static TrillFunction instance;
    private static final String[] NAMES;
    private static final double THIRTY_SECOND_DURATION = 0.03125;

    private TrillFunction() {
    }

    public static TrillFunction getInstance() {
        if (instance == null) {
            instance = new TrillFunction();
        }
        return instance;
    }

    @Override
    public String apply(String parameters, StaccatoParserContext context) {
        StringBuilder buddy = new StringBuilder();
        for (String noteString : parameters.split(" ")) {
            try {
                Note note = NoteProviderFactory.getNoteProvider().createNote(noteString);
                int n = (int)(note.getDuration() / 0.03125);
                for (int i = 0; i < n / 2; ++i) {
                    buddy.append(Note.getToneString(note.getValue()));
                    buddy.append("t ");
                    buddy.append(Note.getToneString((byte)(note.getValue() + 2)));
                    buddy.append("t ");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return buddy.toString().trim();
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    static {
        NAMES = new String[]{"TRILL", "TR"};
    }
}

