/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.staccato.Preprocessor;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;

public class UppercasePreprocessor
implements Preprocessor {
    private static UppercasePreprocessor instance;
    private static char[] SAFECHARS;

    public static UppercasePreprocessor getInstance() {
        if (instance == null) {
            instance = new UppercasePreprocessor();
        }
        return instance;
    }

    @Override
    public String preprocess(String s, StaccatoParserContext context) {
        StringBuilder buddy = new StringBuilder();
        int pos = 0;
        while (pos < s.length()) {
            int upperUntil = StaccatoUtil.findNextOrEnd(s, SAFECHARS, pos);
            if (upperUntil == 0 || s.charAt(upperUntil - 1) == ' ') {
                buddy.append(s.substring(pos, upperUntil).toUpperCase());
                if (upperUntil < s.length()) {
                    int lowerUntil = upperUntil;
                    if (s.charAt(upperUntil + 1) == '(' || s.charAt(upperUntil) == ':') {
                        lowerUntil = s.indexOf(41, upperUntil + 1);
                        buddy.append(s.substring(upperUntil, lowerUntil));
                    } else {
                        lowerUntil = StaccatoUtil.findNextOrEnd(s, ' ', upperUntil);
                        buddy.append(s.substring(upperUntil, lowerUntil));
                    }
                    upperUntil = lowerUntil;
                }
                pos = upperUntil;
                continue;
            }
            int min = Math.min(s.length(), upperUntil + 1);
            buddy.append(s.substring(pos, min).toUpperCase());
            pos = min;
        }
        return buddy.toString();
    }

    static {
        SAFECHARS = new char[]{'\'', '@', '#', '{'};
    }
}

