/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.staccato.Preprocessor;
import org.staccato.StaccatoParserContext;

public class ReplacementMapPreprocessor
implements Preprocessor {
    private static ReplacementMapPreprocessor instance;
    private static Pattern replacementPatternWithBrackets;
    private static Pattern replacementPatternWithoutBrackets;
    private Map<String, String> map;
    private boolean requiresAngleBrackets = true;
    private boolean caseSensitive = false;
    private int iterations = 1;

    private ReplacementMapPreprocessor() {
    }

    public static ReplacementMapPreprocessor getInstance() {
        if (instance == null) {
            instance = new ReplacementMapPreprocessor();
        }
        return instance;
    }

    public ReplacementMapPreprocessor setRequireAngleBrackets(boolean require) {
        this.requiresAngleBrackets = require;
        return this;
    }

    public boolean requiresAngleBrackets() {
        return this.requiresAngleBrackets;
    }

    public ReplacementMapPreprocessor setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public ReplacementMapPreprocessor setReplacementMap(Map<String, String> map) {
        this.map = map;
        return this;
    }

    public ReplacementMapPreprocessor setIterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public int getIterations() {
        return this.iterations;
    }

    private Pattern getReplacementPattern() {
        return this.requiresAngleBrackets() ? replacementPatternWithBrackets : replacementPatternWithoutBrackets;
    }

    @Override
    public String preprocess(String s, StaccatoParserContext context) {
        String iteratingString = s;
        for (int i = 0; i < this.iterations; ++i) {
            StringBuilder buddy = new StringBuilder();
            int posPrev = 0;
            Matcher m = this.getReplacementPattern().matcher(iteratingString);
            while (m.find()) {
                String foundKey = this.requiresAngleBrackets() ? m.group().substring(1, m.group().length() - 1) : m.group();
                buddy.append(iteratingString.substring(posPrev, m.start()));
                String lookupKey = this.isCaseSensitive() ? foundKey : foundKey.toUpperCase();
                String replacementValue = this.map.get(lookupKey);
                if (replacementValue != null) {
                    buddy.append(this.map.get(lookupKey));
                } else {
                    buddy.append(foundKey);
                }
                posPrev = m.end();
            }
            buddy.append(iteratingString.substring(posPrev, iteratingString.length()));
            iteratingString = buddy.toString();
        }
        return iteratingString;
    }

    static {
        replacementPatternWithBrackets = Pattern.compile("<\\S+>");
        replacementPatternWithoutBrackets = Pattern.compile("\\S+");
    }
}

