/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.temporal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jfugue.temporal.DurationTemporalEvent;
import org.jfugue.temporal.TemporalEvent;

final class TemporalEventManager {
    private Map<Long, List<TemporalEvent>> timeToEventMap = new TreeMap<Long, List<TemporalEvent>>();
    private int tempoBeatsPerMinute = 120;
    private int beatsPerWhole = 4;
    private byte currentTrack = 0;
    private byte[] currentLayer = new byte[16];
    private double[][] beatTime = new double[16][16];
    private Map<String, Double> bookmarkedTrackTimeMap;

    public void reset() {
        this.bookmarkedTrackTimeMap = new HashMap<String, Double>();
        this.tempoBeatsPerMinute = 120;
        this.currentTrack = 0;
        for (int i = 0; i < 16; ++i) {
            this.currentLayer[i] = 0;
        }
        this.timeToEventMap.clear();
    }

    public void finish() {
    }

    public void setTempo(int tempoBPM) {
        this.tempoBeatsPerMinute = tempoBPM;
    }

    public void setCurrentTrack(byte track) {
        this.currentTrack = track;
    }

    public void setCurrentLayer(byte layer) {
        this.currentLayer[this.currentTrack] = layer;
    }

    public void advanceTrackBeatTime(double advanceTime) {
        double[] dArray = this.beatTime[this.currentTrack];
        byte by = this.currentLayer[this.currentTrack];
        dArray[by] = dArray[by] + advanceTime;
    }

    public void setTrackBeatTime(double newTime) {
        this.beatTime[this.currentTrack][this.currentLayer[this.currentTrack]] = newTime;
    }

    public double getTrackBeatTime() {
        return this.beatTime[this.currentTrack][this.currentLayer[this.currentTrack]];
    }

    public void addTrackTickTimeBookmark(String timeBookmarkID) {
        this.bookmarkedTrackTimeMap.put(timeBookmarkID, this.getTrackBeatTime());
    }

    public double getTrackBeatTimeBookmark(String timeBookmarkID) {
        return this.bookmarkedTrackTimeMap.get(timeBookmarkID);
    }

    public void addRealTimeEvent(DurationTemporalEvent event) {
        this.addRealTimeEvent((TemporalEvent)event);
        this.advanceTrackBeatTime(event.getDuration());
    }

    public void addRealTimeEvent(TemporalEvent event) {
        List<TemporalEvent> eventList = this.timeToEventMap.get(this.convertBeatsToMillis(this.getTrackBeatTime()));
        if (eventList == null) {
            eventList = new ArrayList<TemporalEvent>();
            this.timeToEventMap.put(this.convertBeatsToMillis(this.getTrackBeatTime()), eventList);
        }
        eventList.add(event);
    }

    public Map<Long, List<TemporalEvent>> getTimeToEventMap() {
        return this.timeToEventMap;
    }

    private long convertBeatsToMillis(double beats) {
        return (long)(beats * (double)this.beatsPerWhole * 60000.0 / (double)this.tempoBeatsPerMinute);
    }
}

