/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.player;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import org.jfugue.player.EndOfTrackListener;

public class SequencerManager {
    private static SequencerManager instance;
    private Sequencer sequencer = this.getDefaultSequencer();
    private CopyOnWriteArrayList<EndOfTrackListener> endOfTrackListeners = new CopyOnWriteArrayList();

    public static SequencerManager getInstance() throws MidiUnavailableException {
        if (instance == null) {
            instance = new SequencerManager();
        }
        return instance;
    }

    public Sequencer getDefaultSequencer() throws MidiUnavailableException {
        return MidiSystem.getSequencer();
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    public void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    public Sequencer openSequencer() throws MidiUnavailableException {
        if (!this.sequencer.isOpen()) {
            this.sequencer.open();
            this.sequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage event) {
                    if (event.getType() == 47) {
                        SequencerManager.this.fireEndOfTrack();
                    }
                }
            });
        }
        return this.sequencer;
    }

    public void close() {
        if (this.sequencer == null) {
            return;
        }
        if (this.sequencer.isOpen()) {
            this.sequencer.close();
        }
    }

    public void connectSequencerToSynthesizer(Synthesizer synth) throws MidiUnavailableException {
        if (!synth.isOpen()) {
            synth.open();
        }
        this.openSequencer().getTransmitter().setReceiver(synth.getReceiver());
    }

    public void addEndOfTrackListener(EndOfTrackListener listener) {
        this.endOfTrackListeners.add(listener);
    }

    public void removeEndOfTrackListener(EndOfTrackListener listener) {
        this.endOfTrackListeners.add(listener);
    }

    public List<EndOfTrackListener> getEndOfTrackListeners() {
        return this.endOfTrackListeners;
    }

    protected void fireEndOfTrack() {
        List<EndOfTrackListener> listeners = this.getEndOfTrackListeners();
        for (EndOfTrackListener listener : listeners) {
            listener.onEndOfTrack();
        }
    }
}

