/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.player;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import org.jfugue.midi.MidiParserListener;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.player.ManagedPlayer;
import org.staccato.StaccatoParser;

public class Player {
    private StaccatoParser staccatoParser;
    private MidiParserListener midiParserListener;
    private ManagedPlayer managedPlayer = new ManagedPlayer();

    public Player() {
        this.staccatoParser = new StaccatoParser();
        this.midiParserListener = new MidiParserListener();
        this.staccatoParser.addParserListener(this.midiParserListener);
    }

    public Sequence getSequence(PatternProducer ... patternProducers) {
        return this.getSequence((PatternProducer)new Pattern(patternProducers));
    }

    public Sequence getSequence(PatternProducer patternProducer) {
        return this.getSequence(patternProducer.getPattern().toString());
    }

    public Sequence getSequence(String ... strings) {
        return this.getSequence((PatternProducer)new Pattern(strings));
    }

    public Sequence getSequence(String string) {
        this.staccatoParser.parse(string);
        return this.midiParserListener.getSequence();
    }

    public void play(PatternProducer ... patternProducers) {
        this.play((PatternProducer)new Pattern(patternProducers));
    }

    public void play(PatternProducer patternProducer) {
        this.play(patternProducer.getPattern().toString());
    }

    public void play(String ... strings) {
        this.play((PatternProducer)new Pattern(strings));
    }

    public void play(String string) {
        this.play(this.getSequence(string));
    }

    public void play(Sequence sequence) {
        try {
            this.managedPlayer.start(sequence);
        }
        catch (InvalidMidiDataException e) {
            throw new RuntimeException(e);
        }
        catch (MidiUnavailableException e) {
            throw new RuntimeException(e);
        }
        while (!this.managedPlayer.isFinished()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void delayPlay(long millisToDelay, PatternProducer ... patternProducers) {
        this.delayPlay(millisToDelay, (PatternProducer)new Pattern(patternProducers));
    }

    public void delayPlay(long millisToDelay, PatternProducer patternProducer) {
        this.delayPlay(millisToDelay, patternProducer.getPattern().toString());
    }

    public void delayPlay(long millisToDelay, String ... strings) {
        this.delayPlay(millisToDelay, (PatternProducer)new Pattern(strings));
    }

    public void delayPlay(long millisToDelay, String string) {
        this.delayPlay(millisToDelay, this.getSequence(string));
    }

    public void delayPlay(final long millisToDelay, final Sequence sequence) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(millisToDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Player.this.play(sequence);
            }
        };
        thread.start();
    }

    public ManagedPlayer getManagedPlayer() {
        return this.managedPlayer;
    }

    public StaccatoParser getStaccatoParser() {
        return this.staccatoParser;
    }

    public MidiParserListener getMidiParserListener() {
        return this.midiParserListener;
    }
}

