/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.parser;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jfugue.parser.ParserListener;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class Parser {
    private CopyOnWriteArrayList<ParserListener> parserListeners = new CopyOnWriteArrayList();

    public void addParserListener(ParserListener listener) {
        this.parserListeners.add(listener);
    }

    public void removeParserListener(ParserListener listener) {
        this.parserListeners.add(listener);
    }

    public List<ParserListener> getParserListeners() {
        return this.parserListeners;
    }

    public void fireBeforeParsingStarts() {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.beforeParsingStarts();
        }
    }

    public void fireAfterParsingFinished() {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.afterParsingFinished();
        }
    }

    public void fireTrackChanged(byte track) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onTrackChanged(track);
        }
    }

    public void fireLayerChanged(byte layer) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onLayerChanged(layer);
        }
    }

    public void fireInstrumentParsed(byte instrument) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onInstrumentParsed(instrument);
        }
    }

    public void fireTempoChanged(int tempoBPM) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onTempoChanged(tempoBPM);
        }
    }

    public void fireKeySignatureParsed(byte key, byte scale) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onKeySignatureParsed(key, scale);
        }
    }

    public void fireTimeSignatureParsed(byte numerator, byte powerOfTwo) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onTimeSignatureParsed(numerator, powerOfTwo);
        }
    }

    public void fireBarLineParsed(long id) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onBarLineParsed(id);
        }
    }

    public void fireTrackBeatTimeBookmarked(String timeBookmarkId) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onTrackBeatTimeBookmarked(timeBookmarkId);
        }
    }

    public void fireTrackBeatTimeBookmarkRequested(String timeBookmarkId) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onTrackBeatTimeBookmarkRequested(timeBookmarkId);
        }
    }

    public void fireTrackBeatTimeRequested(double time) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onTrackBeatTimeRequested(time);
        }
    }

    public void firePitchWheelParsed(byte lsb, byte msb) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onPitchWheelParsed(lsb, msb);
        }
    }

    public void fireChannelPressureParsed(byte pressure) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onChannelPressureParsed(pressure);
        }
    }

    public void firePolyphonicPressureParsed(byte key, byte pressure) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onPolyphonicPressureParsed(key, pressure);
        }
    }

    public void fireSystemExclusiveParsed(byte ... bytes) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onSystemExclusiveParsed(bytes);
        }
    }

    public void fireControllerEventParsed(byte controller, byte value) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onControllerEventParsed(controller, value);
        }
    }

    public void fireLyricParsed(String lyric) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onLyricParsed(lyric);
        }
    }

    public void fireMarkerParsed(String marker) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onMarkerParsed(marker);
        }
    }

    public void fireFunctionParsed(String id, Object message) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onFunctionParsed(id, message);
        }
    }

    public void fireNoteParsed(Note note) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onNoteParsed(note);
        }
    }

    public void fireChordParsed(Chord chord) {
        List<ParserListener> listeners = this.getParserListeners();
        for (ParserListener listener : listeners) {
            listener.onChordParsed(chord);
        }
    }
}

