/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.jfugue.integration.XMLpart;
import org.jfugue.integration.voiceDef;
import org.jfugue.midi.MidiDictionary;
import org.jfugue.parser.Parser;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.staccato.DefaultNoteSettingsManager;

public final class MusicXmlParser_J
extends Parser {
    private Builder xomBuilder;
    private Document xomDoc;
    private String[] volumes = new String[]{"pppppp", "ppppp", "pppp", "ppp", "pp", "p", "mp", "mf", "f", "ff", "fff", "ffff", "fffff", "ffffff"};
    private byte minVelocity = (byte)10;
    private byte maxVelocity = (byte)127;
    private byte curVelocity = DefaultNoteSettingsManager.getInstance().getDefaultOnVelocity();
    private byte beats = 1;
    private byte divisions = 1;
    private int curVoice = -1;
    private byte curLayer;
    private byte[] curKey = new byte[]{0, 0};
    private byte nextVoice = 0;
    private voiceDef[] voices;
    private Logger logger = Logger.getLogger("org.jfugue");
    private double totalMeasurePct;
    public static Map<String, String> XMLtoJFchordMap = new TreeMap<String, String>(new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int result = this.compareLength(s1, s2);
            if (result == 0) {
                result = s1.compareTo(s2);
            }
            return result;
        }

        private int compareLength(String s1, String s2) {
            if (s1.length() < s2.length()) {
                return 1;
            }
            if (s1.length() > s2.length()) {
                return -1;
            }
            return 0;
        }
    });
    private int tempo = 120;

    public MusicXmlParser_J() throws ParserConfigurationException {
        this.xomBuilder = new Builder();
        this.voices = new voiceDef[15];
    }

    public void parse(String musicXmlString) throws ValidityException, ParsingException, IOException {
        this.xomDoc = this.xomBuilder.build(musicXmlString, (String)null);
        this.parse();
    }

    public void parse(File fileXMLin) throws ValidityException, ParsingException, IOException {
        System.out.println("attempting to build file");
        this.xomDoc = this.xomBuilder.build(fileXMLin);
        this.parse();
    }

    public void parse(FileInputStream fisXMLin) throws ValidityException, ParsingException, IOException {
        this.xomDoc = this.xomBuilder.build((InputStream)fisXMLin);
        this.parse();
    }

    public void parse(Reader rXMLin) throws ValidityException, ParsingException, IOException {
        this.xomDoc = this.xomBuilder.build(rXMLin);
        this.parse();
    }

    protected void setTempo(int tempo) {
        this.tempo = tempo;
    }

    protected int getTempo() {
        return this.tempo;
    }

    public void parse() {
        DocType docType = this.xomDoc.getDocType();
        this.logger.log(Level.INFO, "DocType = {0}", this.xomDoc.getDocType().toXML());
        this.logger.log(Level.INFO, "Score Partwise Check");
        Element root = this.xomDoc.getRootElement();
        this.logger.log(Level.INFO, "Root Element = {0}", this.xomDoc.getDocType().getRootElementName());
        if (docType.getRootElementName().compareToIgnoreCase("score-timewise") == 0) {
            // empty if block
        }
        if (docType.getRootElementName().compareToIgnoreCase("score-partwise") == 0) {
            int p;
            Element partlist = root.getFirstChildElement("part-list");
            Elements parts = partlist.getChildElements();
            Integer part_list_size = parts.size();
            if (parts.size() == 1) {
                System.out.println("part list size = 1");
            }
            XMLpart[] partHeaders = new XMLpart[parts.size()];
            for (p = 0; p < parts.size(); ++p) {
                System.out.println("score part " + p);
                partHeaders[p] = new XMLpart();
                this.logger.log(Level.INFO, "Parsing a Part Header");
                this.parsePartHeader(parts.get(p), partHeaders[p]);
            }
            parts = root.getChildElements("part");
            for (p = 0; p < parts.size(); ++p) {
                this.logger.log(Level.INFO, "Parsing a Part");
                this.parsePart(p, parts.get(p), partHeaders);
            }
        }
    }

    private void parsePartHeader(Element part, XMLpart partHeader) {
        int x;
        if (part.getLocalName().equals("part-group")) {
            return;
        }
        Attribute ID = part.getAttribute("id");
        partHeader.ID = ID.getValue();
        Element partName = part.getFirstChildElement("part-name");
        partHeader.part_name = partName.getValue();
        this.logger.log(Level.INFO, "ID = {0}", partHeader.ID);
        this.logger.log(Level.INFO, "part_name = {0} ", partHeader.part_name);
        Elements scoreInsts = part.getChildElements("score-instrument");
        for (x = 0; x < scoreInsts.size(); ++x) {
            this.logger.log(Level.INFO, "Processing Score-instrument String");
            partHeader.score_instruments = partHeader.score_instruments + scoreInsts.get(x).getValue();
            if (x >= scoreInsts.size() - 1) continue;
            partHeader.score_instruments = partHeader.score_instruments + "~";
        }
        this.logger.log(Level.INFO, "Score Instruments String = {0} ", partHeader.score_instruments);
        Elements midiInsts = part.getChildElements("midi-instrument");
        for (x = 0; x < midiInsts.size(); ++x) {
            String midi_unpitched_str;
            Element midi_program;
            String midi_program_str;
            Element midi_bank;
            String midi_bank_str;
            String midiInstName_str;
            String midiChannel_str;
            String midi_instID_str;
            Element midi_instrument = midiInsts.get(x);
            Attribute midi_instID = midi_instrument.getAttribute("id");
            partHeader.midi_instruments[x][0] = midi_instID_str = midi_instID.getValue();
            this.logger.log(Level.INFO, "Midi Instrument ID = {0}", partHeader.midi_instruments[x][0]);
            Element midi_channel = midi_instrument.getFirstChildElement("midi-channel");
            String string = midiChannel_str = midi_channel == null ? "" : midi_channel.getValue();
            if (midiChannel_str.length() > 0) {
                partHeader.midi_instruments[x][1] = midiChannel_str;
            }
            this.logger.log(Level.INFO, "Midi Instrument Channel = {0}", partHeader.midi_instruments[x][1]);
            Element midi_inst = midi_instrument.getFirstChildElement("midi-name");
            String string2 = midiInstName_str = midi_inst == null ? "" : midi_inst.getValue();
            if (midiInstName_str.length() > 0) {
                partHeader.midi_instruments[x][2] = midiInstName_str;
            }
            String string3 = midi_bank_str = (midi_bank = midi_instrument.getFirstChildElement("midi-bank")) == null ? "" : midi_bank.getValue();
            if (midi_bank_str.length() > 0) {
                partHeader.midi_instruments[x][3] = midi_bank_str;
            }
            partHeader.midi_instruments[x][4] = midi_program_str = (midi_program = midi_instrument.getFirstChildElement("midi-program")) == null ? "" : midi_program.getValue();
            Element midi_unpitched = midi_instrument.getFirstChildElement("midi-unpitched");
            partHeader.midi_instruments[x][5] = midi_unpitched_str = midi_unpitched == null ? "" : midi_unpitched.getValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePart(int p, Element part, XMLpart[] partHeaders) {
        for (int x = 0; x < partHeaders.length; ++x) {
            if (!part.getAttribute("id").getValue().equals(partHeaders[x].ID)) continue;
            this.logger.log(Level.INFO, "part number: {0}", x);
            this.logger.log(Level.INFO, "Midi Instruments in part = {0}", partHeaders[x].midi_instruments.length);
            if (partHeaders[x].midi_instruments[0] == null) {
                this.parseVoice(p, x);
                this.parseInstrument(partHeaders[x].part_name);
                this.curLayer = 0;
                this.fireLayerChanged(this.curLayer);
                continue;
            }
            if (partHeaders[x].midi_instruments[0][1] != null) {
                this.parseVoice(p, Integer.parseInt(partHeaders[x].midi_instruments[0][1]));
            }
            this.logger.log(Level.INFO, "Passing {0} to parseInstrument", partHeaders[x].midi_instruments[0][4]);
            this.parseInstrument(partHeaders[x].midi_instruments[0][4]);
            this.curLayer = 0;
            this.fireLayerChanged(this.curLayer);
        }
        Elements measures = part.getChildElements("measure");
        for (int m = 0; m < measures.size(); ++m) {
            Element metronome;
            Element directionType;
            Element measure = measures.get(m);
            Element attributes = measure.getFirstChildElement("attributes");
            if (attributes != null) {
                Element element_beats;
                Element element_time;
                Element element_divisions;
                byte key = 0;
                byte scale = 0;
                Element attr = attributes.getFirstChildElement("key");
                if (attr != null) {
                    Element eMode;
                    Element eKey = attr.getFirstChildElement("fifths");
                    if (eKey != null) {
                        key = Byte.parseByte(eKey.getValue());
                    }
                    if ((eMode = attr.getFirstChildElement("mode")) != null) {
                        String mode = eMode.getValue();
                        if (mode.compareToIgnoreCase("major") == 0) {
                            scale = 0;
                        } else {
                            if (mode.compareToIgnoreCase("minor") != 0) throw new RuntimeException("Error in key signature: " + mode);
                            scale = 1;
                        }
                    }
                } else {
                    scale = 0;
                }
                this.logger.log(Level.INFO, "Key Signature = " + key + scale);
                if (key != this.curKey[0] || scale != this.curKey[1]) {
                    this.fireKeySignatureParsed(key, scale);
                    this.curKey[0] = key;
                    this.curKey[1] = scale;
                }
                if ((element_divisions = attributes.getFirstChildElement("divisions")) != null) {
                    this.divisions = Byte.valueOf(element_divisions.getValue());
                }
                if ((element_time = attributes.getFirstChildElement("time")) != null && (element_beats = element_time.getFirstChildElement("beats")) != null) {
                    this.beats = Byte.valueOf(element_beats.getValue());
                }
            }
            this.logger.log(Level.INFO, "Time Signature = " + this.divisions + "/" + this.beats);
            Element direction = measure.getFirstChildElement("direction");
            if (direction != null && (directionType = direction.getFirstChildElement("direction-type")) != null && (metronome = directionType.getFirstChildElement("metronome")) != null) {
                Element beatUnit = metronome.getFirstChildElement("beat-unit");
                String sBeatUnit = beatUnit.getValue();
                if (sBeatUnit.compareToIgnoreCase("quarter") != 0) {
                    throw new RuntimeException("Beat unit must be quarter: " + sBeatUnit);
                }
                Element bpm = metronome.getFirstChildElement("per-minute");
                if (bpm != null) {
                    this.setTempo(MusicXmlParser_J.BPMtoPPM(Float.parseFloat(bpm.getValue())));
                    this.fireTempoChanged(this.getTempo());
                }
            }
            Elements chords = measure.getChildElements("harmony");
            for (int n = 0; n < chords.size(); ++n) {
                this.parseChord(p, chords.get(n));
            }
            Elements notes = measure.getChildElements("note");
            for (int n = 0; n < notes.size(); ++n) {
                this.parseNote(p, notes.get(n), part, partHeaders);
            }
            this.fireBarLineParsed(0L);
        }
    }

    private void parseChord(int p, Element harmony) {
        Element chord_bass;
        Element chord_inv;
        Element chord_kind;
        String chord_string = " ";
        Element chord_root = harmony.getFirstChildElement("root");
        if (chord_root != null) {
            Element chord_root_alter;
            Element chord_root_step = chord_root.getFirstChildElement("root-step");
            if (chord_root_step != null) {
                chord_string = chord_root_step.getValue();
            }
            if ((chord_root_alter = chord_root.getFirstChildElement("root-alter")) != null) {
                if (chord_root_alter.getValue() == "-1") {
                    chord_string = chord_string + "b";
                }
                if (chord_root_alter.getValue() == "+1") {
                    chord_string = chord_string + "#";
                }
            }
        }
        if ((chord_kind = harmony.getFirstChildElement("kind")) != null) {
            String chord_kind_str = XMLtoJFchordMap.get(chord_kind.getValue());
            chord_string = chord_string + (chord_kind_str == null ? "" : chord_kind_str);
        }
        if ((chord_inv = harmony.getFirstChildElement("inversion")) != null) {
            Integer inv_value = Integer.parseInt(chord_inv.getValue());
            Integer i = 0;
            while (i < inv_value) {
                chord_string = chord_string + "^";
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        if ((chord_bass = harmony.getFirstChildElement("bass")) != null) {
            Element chord_bass_alter;
            Element chord_bass_step = chord_bass.getFirstChildElement("bass-step");
            if (chord_bass_step != null) {
                chord_string = chord_bass_step.getValue();
            }
            if ((chord_bass_alter = chord_bass.getFirstChildElement("bass-alter")) != null) {
                if (chord_bass_alter.getValue() == "-1") {
                    chord_string = chord_string + "b";
                }
                if (chord_bass_alter.getValue() == "+1") {
                    chord_string = chord_string + "#";
                }
            }
        }
        this.logger.log(Level.INFO, "Chord = {0}", chord_string);
        Chord newChord = new Chord(chord_string);
        this.fireChordParsed(newChord);
    }

    private void parseNote(int p, Element note, Element part, XMLpart[] partHeaders) {
        Element lyric_text_element;
        Element pitch;
        Element voice;
        Element unpitched;
        Note newNote = new Note();
        boolean isRest = false;
        boolean isStartOfTie = false;
        boolean isEndOfTie = false;
        byte noteNumber = 0;
        int octaveNumber = 0;
        if (note.getFirstChildElement("grace") != null) {
            return;
        }
        this.logger.log(Level.INFO, "Parsing Note");
        Elements note_elements = note.getChildElements();
        for (int i = 0; i < note_elements.size(); ++i) {
            if (!note_elements.get(i).getQualifiedName().equals("chord")) continue;
            newNote.setHarmonicNote(true);
        }
        Element note_instrument = note.getFirstChildElement("instrument");
        if (note_instrument != null) {
            for (int x = 0; x < partHeaders.length; ++x) {
                if (!part.getAttribute("ID").equals((Object)partHeaders[x].ID)) continue;
                for (int y = 0; y < partHeaders[x].midi_instruments.length; ++y) {
                    if (partHeaders[x].midi_instruments[y][0] != note_instrument.getAttributeValue("ID").toString()) continue;
                    this.logger.log(Level.INFO, "Part Headers entry: {0}", partHeaders[x].midi_instruments[y][0]);
                    this.logger.log(Level.INFO, "Instrument ID {0}", note_instrument.getAttributeValue("ID").toString());
                    this.logger.log(Level.INFO, "Part Headers Name: {0}", partHeaders[x].midi_instruments[y][1]);
                    this.parseVoice(p, Integer.parseInt(partHeaders[x].midi_instruments[y][0]));
                    this.parseInstrument(partHeaders[x].midi_instruments[y][1]);
                }
            }
        }
        if ((unpitched = note.getFirstChildElement("unpitched")) != null) {
            newNote.setPercussionNote(true);
            Element display_note = unpitched.getFirstChildElement("display-step");
            Element display_octave = unpitched.getFirstChildElement("display-octave");
            if (display_note != null) {
                String sdisplay_note = display_note.getValue();
                switch (sdisplay_note.charAt(0)) {
                    case 'C': {
                        noteNumber = 0;
                        break;
                    }
                    case 'D': {
                        noteNumber = 2;
                        break;
                    }
                    case 'E': {
                        noteNumber = 4;
                        break;
                    }
                    case 'F': {
                        noteNumber = 5;
                        break;
                    }
                    case 'G': {
                        noteNumber = 7;
                        break;
                    }
                    case 'A': {
                        noteNumber = 9;
                        break;
                    }
                    case 'B': {
                        noteNumber = 11;
                    }
                }
            }
            if (display_octave != null) {
                Byte octave_byte = new Byte(display_octave.getValue());
                noteNumber = (byte)(noteNumber + octave_byte * 12);
                System.out.println("percussion Note display pitch " + display_note.getValue() + display_octave.getValue() + "maps to notenumber value " + noteNumber);
            }
        }
        if ((voice = note.getFirstChildElement("voice")) != null && !newNote.isHarmonicNote() && Byte.parseByte(voice.getValue()) - 1 != this.curLayer) {
            this.curLayer = Byte.parseByte(voice.getValue());
            this.curLayer = (byte)(this.curLayer - 1);
            this.fireLayerChanged(this.curLayer);
        }
        if ((pitch = note.getFirstChildElement("pitch")) != null) {
            int intNoteNumber;
            Element octave;
            String sAlter;
            String sStep = pitch.getFirstChildElement("step").getValue();
            switch (sStep.charAt(0)) {
                case 'C': {
                    noteNumber = 0;
                    break;
                }
                case 'D': {
                    noteNumber = 2;
                    break;
                }
                case 'E': {
                    noteNumber = 4;
                    break;
                }
                case 'F': {
                    noteNumber = 5;
                    break;
                }
                case 'G': {
                    noteNumber = 7;
                    break;
                }
                case 'A': {
                    noteNumber = 9;
                    break;
                }
                case 'B': {
                    noteNumber = 11;
                }
            }
            Element alter = pitch.getFirstChildElement("alter");
            if (alter != null && (sAlter = alter.getValue()) != null) {
                if ((noteNumber = (byte)((byte)(noteNumber + Integer.parseInt(sAlter)))) > 11) {
                    noteNumber = 0;
                } else if (noteNumber < 0) {
                    noteNumber = 11;
                }
            }
            if ((octave = pitch.getFirstChildElement("octave")) != null) {
                String sOctave = octave.getValue();
                this.logger.log(Level.INFO, "Octave Value: {0}", sOctave);
                if (sOctave != null) {
                    octaveNumber = Byte.parseByte(sOctave);
                }
            }
            if ((intNoteNumber = octaveNumber * 12 + noteNumber) > 127) {
                throw new RuntimeException("Note value " + intNoteNumber + " is larger than 127");
            }
            noteNumber = (byte)intNoteNumber;
        } else if (!newNote.isPercussionNote()) {
            isRest = true;
        }
        Element element_duration = note.getFirstChildElement("duration");
        double decimalDuration = element_duration == null ? (double)(this.beats * this.divisions) : Double.parseDouble(element_duration.getValue()) / (double)(this.beats * this.divisions);
        double PPW = (double)this.getTempo() * 4.0;
        Element notations = note.getFirstChildElement("notations");
        if (notations != null) {
            Node dynamic;
            Element dynamics;
            Element tied = notations.getFirstChildElement("tied");
            if (tied != null) {
                Attribute tiedType = tied.getAttribute("type");
                String sTiedType = tiedType.getValue();
                if (sTiedType.compareToIgnoreCase("start") == 0) {
                    isStartOfTie = true;
                } else if (sTiedType.compareToIgnoreCase("end") == 0) {
                    isEndOfTie = true;
                }
                this.logger.log(Level.INFO, "Is start of tie = {0}", isStartOfTie);
                this.logger.log(Level.INFO, "TiedType = {0}", sTiedType);
            }
            if ((dynamics = notations.getFirstChildElement("dynamics")) != null && (dynamic = dynamics.getChild(0)) != null) {
                for (int x = 0; x < this.volumes.length; ++x) {
                    if (dynamic.getValue().compareToIgnoreCase(this.volumes[x]) != 0) continue;
                    this.curVelocity = (byte)((this.maxVelocity - this.minVelocity) / (this.volumes.length - 1) * x);
                }
            }
        }
        byte attackVelocity = this.curVelocity;
        byte decayVelocity = this.curVelocity;
        if (isRest) {
            newNote.setRest(true);
            newNote.setDuration(decimalDuration);
            newNote.setOnVelocity((byte)0);
            newNote.setOffVelocity((byte)0);
        } else {
            newNote.setValue(noteNumber);
            newNote.setDuration(decimalDuration);
            newNote.setStartOfTie(isStartOfTie);
            newNote.setEndOfTie(isEndOfTie);
            newNote.setOnVelocity(attackVelocity);
            newNote.setOffVelocity(decayVelocity);
        }
        newNote.setDuration(decimalDuration);
        this.logger.log(Level.INFO, "note duration = {0}", newNote.getDuration());
        if (newNote.isHarmonicNote()) {
            System.out.println("this is harmonic note");
        }
        System.out.println(newNote.toDebugString());
        this.fireNoteParsed(newNote);
        Element lyric = note.getFirstChildElement("lyric");
        if (lyric != null && (lyric_text_element = lyric.getFirstChildElement("text")) != null) {
            String lyric_text_string = lyric_text_element.getValue();
            this.fireLyricParsed(lyric_text_string);
        }
    }

    private void parseVoice(int p, int v) {
        if (v == 10) {
            this.fireTrackChanged((byte)v);
        } else {
            int voiceNumber = -1;
            for (byte x = 0; x < this.nextVoice; x = (byte)(x + 1)) {
                if (p != this.voices[x].part || v != this.voices[x].voice) continue;
                voiceNumber = x;
            }
            if (voiceNumber == -1) {
                voiceNumber = this.nextVoice;
                this.voices[voiceNumber] = new voiceDef();
                this.voices[voiceNumber].part = p;
                this.voices[voiceNumber].voice = v;
                this.nextVoice = (byte)(this.nextVoice + 1);
            }
            if (voiceNumber != this.curVoice) {
                this.fireTrackChanged((byte)voiceNumber);
            }
            this.curVoice = voiceNumber;
        }
    }

    private void parseInstrument(String inst) {
        byte instrumentNumber;
        this.logger.log(Level.INFO, "Starting parseInstrument");
        try {
            instrumentNumber = Byte.parseByte(inst);
        }
        catch (NumberFormatException e) {
            Byte value = MidiDictionary.INSTRUMENT_STRING_TO_BYTE.get(inst);
            instrumentNumber = value == null ? (byte)-1 : (byte)value;
        }
        this.logger.log(Level.INFO, "Instrument element: inst = {0}", inst);
        this.logger.log(Level.INFO, "Instrument number:  {0}", instrumentNumber);
        if (instrumentNumber > -1) {
            this.fireInstrumentParsed(instrumentNumber);
        }
    }

    public static int BPMtoPPM(float bpm) {
        return new Float(14400.0f / bpm).intValue();
    }

    static {
        XMLtoJFchordMap.put("major", "MAJ");
        XMLtoJFchordMap.put("major-sixth", "MAJ6");
        XMLtoJFchordMap.put("major-seventh", "MAJ7");
        XMLtoJFchordMap.put("major-ninth", "MAJ9");
        XMLtoJFchordMap.put("major-13th", "MAJ13");
        XMLtoJFchordMap.put("minor", "MIN");
        XMLtoJFchordMap.put("minor-sixth", "MIN6");
        XMLtoJFchordMap.put("minor-seventh", "MIN7");
        XMLtoJFchordMap.put("minor-ninth", "MIN9");
        XMLtoJFchordMap.put("minor-11th", "MIN11");
        XMLtoJFchordMap.put("major-minor", "MINMAJ7");
        XMLtoJFchordMap.put("dominant", "DOM7");
        XMLtoJFchordMap.put("dominant-11th", "DOM7%11");
        XMLtoJFchordMap.put("dominant-ninth", "DOM9");
        XMLtoJFchordMap.put("dominant-13th", "DOM13");
        XMLtoJFchordMap.put("augmented", "AUG");
        XMLtoJFchordMap.put("augmented-seventh", "AUG7");
        XMLtoJFchordMap.put("diminished", "DIM");
        XMLtoJFchordMap.put("diminished-seventh", "DIM7");
        XMLtoJFchordMap.put("suspended-fourth", "SUS4");
        XMLtoJFchordMap.put("suspended-second", "SUS2");
    }
}

