/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.integration;

import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.jfugue.parser.ParserListener;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class MusicXmlParserListener
implements ParserListener {
    private Element root = new Element("score-partwise");
    private Element elCurMeasure;
    private Element elPartList;
    private Element elCurScorePart;
    private Element elCurPart;
    private static final int MUSICXMLDIVISIONS = 4;
    private static final double WHOLE = 1024.0;
    private static final double QUARTER = 256.0;

    public MusicXmlParserListener() {
        Element elID = new Element("identification");
        Element elCreator = new Element("creator");
        elCreator.addAttribute(new Attribute("type", "software"));
        elCreator.appendChild("JFugue MusicXMLRenderer");
        elID.appendChild((Node)elCreator);
        this.root.appendChild((Node)elID);
        this.elPartList = new Element("part-list");
        this.root.appendChild((Node)this.elPartList);
    }

    public String getMusicXMLString() {
        return this.getMusicXMLDoc().toXML();
    }

    public Document getMusicXMLDoc() {
        Elements elDocParts = this.root.getChildElements("part");
        for (int xP = 0; xP < elDocParts.size(); ++xP) {
            Element elDocPart = elDocParts.get(xP);
            Elements elPartMeasures = elDocPart.getChildElements("measure");
            for (int xM = 0; xM < elPartMeasures.size(); ++xM) {
                if (elPartMeasures.get(xM).getChildCount() >= 1) continue;
                elDocPart.removeChild(xM);
            }
        }
        Document xomDoc = new Document(this.root);
        DocType docType = new DocType("score-partwise", "-//Recordare//DTD MusicXML 1.1 Partwise//EN", "http://www.musicxml.org/dtds/partwise.dtd");
        xomDoc.insertChild((Node)docType, 0);
        return xomDoc;
    }

    @Override
    public void beforeParsingStarts() {
    }

    @Override
    public void afterParsingFinished() {
    }

    @Override
    public void onTrackChanged(byte track) {
    }

    @Override
    public void onLayerChanged(byte layer) {
    }

    @Override
    public void onInstrumentParsed(byte instrument) {
    }

    @Override
    public void onTempoChanged(int tempoBPM) {
    }

    @Override
    public void onKeySignatureParsed(byte key, byte scale) {
    }

    @Override
    public void onTimeSignatureParsed(byte numerator, byte denominator) {
    }

    @Override
    public void onBarLineParsed(long id) {
    }

    @Override
    public void onTrackBeatTimeBookmarked(String timeBookmarkId) {
    }

    @Override
    public void onTrackBeatTimeBookmarkRequested(String timeBookmarkId) {
    }

    @Override
    public void onTrackBeatTimeRequested(double time) {
    }

    @Override
    public void onPitchWheelParsed(byte lsb, byte msb) {
    }

    @Override
    public void onChannelPressureParsed(byte pressure) {
    }

    @Override
    public void onPolyphonicPressureParsed(byte key, byte pressure) {
    }

    @Override
    public void onSystemExclusiveParsed(byte ... bytes) {
    }

    @Override
    public void onControllerEventParsed(byte controller, byte value) {
    }

    @Override
    public void onLyricParsed(String lyric) {
    }

    @Override
    public void onMarkerParsed(String marker) {
    }

    @Override
    public void onFunctionParsed(String id, Object message) {
    }

    @Override
    public void onNoteParsed(Note note) {
    }

    @Override
    public void onChordParsed(Chord chord) {
    }
}

