/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.wiiusejevents.physicalevents;

import wiiusej.values.GForce;
import wiiusej.values.Orientation;
import wiiusej.values.RawAcceleration;
import wiiusej.wiiusejevents.GenericEvent;

public class MotionSensingEvent
extends GenericEvent {
    private Orientation orientation;
    private GForce gforce;
    private RawAcceleration acceleration;
    private float orientationThreshold = 0.0f;
    private int accelerationThreshold = 0;
    private float alphaSmoothing = 0.0f;
    private boolean isSmoothingActive = false;

    public MotionSensingEvent(int id, float orientationThreshold, int accelerationThreshold, boolean smoothingState, float alphaSmooth, float r, float p, float ya, float ar, float ap, float x, float y, float z, short xx, short yy, short zz) {
        super(id);
        this.orientationThreshold = orientationThreshold;
        this.accelerationThreshold = accelerationThreshold;
        this.isSmoothingActive = smoothingState;
        this.alphaSmoothing = alphaSmooth;
        this.setOrientationAndGforce(r, p, ya, ar, ap, x, y, z, xx, yy, zz);
    }

    private void setOrientationAndGforce(float r, float p, float ya, float ar, float ap, float x, float y, float z, short xx, short yy, short zz) {
        this.orientation = new Orientation(r, p, ya, ar, ap);
        this.gforce = new GForce(x, y, z);
        this.acceleration = new RawAcceleration(xx, yy, zz);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public GForce getGforce() {
        return this.gforce;
    }

    public RawAcceleration getRawAcceleration() {
        return this.acceleration;
    }

    public float getOrientationThreshold() {
        return this.orientationThreshold;
    }

    public int getAccelerationThreshold() {
        return this.accelerationThreshold;
    }

    public float getAlphaSmoothing() {
        return this.alphaSmoothing;
    }

    public boolean isSmoothingActive() {
        return this.isSmoothingActive;
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + "/******** Motion sensing ********/\n";
        out = String.valueOf(out) + "--- Motion sensing : true \n";
        out = String.valueOf(out) + "--- Orientation threshold value ? : " + this.orientationThreshold + "\n";
        out = String.valueOf(out) + "--- Acceleration threshold value ? : " + this.accelerationThreshold + "\n";
        out = String.valueOf(out) + "--- Alpha smoothing threshold value ? : " + this.alphaSmoothing + "\n";
        out = String.valueOf(out) + "--- Smoothing ? : " + this.isSmoothingActive + "\n";
        out = String.valueOf(out) + "--- " + this.orientation + "\n";
        out = String.valueOf(out) + "--- " + this.gforce + "\n";
        out = String.valueOf(out) + "--- " + this.acceleration + "\n";
        return out;
    }
}

