/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.wiiusejevents.physicalevents;

import wiiusej.wiiusejevents.GenericEvent;

public abstract class ButtonsEvent
extends GenericEvent {
    private short buttonsJustPressed = 0;
    private short buttonsJustReleased = 0;
    private short buttonsHeld = 0;

    public ButtonsEvent(int id, short buttonsJustPressed, short buttonsJustReleased, short buttonsHeld) {
        super(id);
        this.setAllButtons(buttonsJustPressed, buttonsJustReleased, buttonsHeld);
    }

    private void setAllButtons(short buttonsJustPressed, short buttonsJustReleased, short buttonsHeld) {
        this.buttonsJustPressed = buttonsJustPressed;
        this.buttonsJustReleased = buttonsJustReleased;
        this.buttonsHeld = buttonsHeld;
    }

    public short getButtonsJustPressed() {
        return this.buttonsJustPressed;
    }

    public short getButtonsJustReleased() {
        return this.buttonsJustReleased;
    }

    public short getButtonsHeld() {
        return this.buttonsHeld;
    }

    protected boolean buttonTest(int buttonBitsDefinition, int buttons) {
        return (buttons & buttonBitsDefinition) == buttonBitsDefinition;
    }

    protected boolean isButtonJustPressed(int buttonBitsDefinition) {
        return this.buttonTest(buttonBitsDefinition, this.buttonsJustPressed) && !this.isButtonHeld(buttonBitsDefinition);
    }

    protected boolean isButtonJustReleased(int buttonBitsDefinition) {
        return this.buttonTest(buttonBitsDefinition, this.buttonsJustReleased);
    }

    protected boolean isButtonHeld(int buttonBitsDefinition) {
        return this.buttonTest(buttonBitsDefinition, this.buttonsHeld);
    }

    protected boolean isButtonPressed(int buttonBitsDefinition) {
        return this.isButtonHeld(buttonBitsDefinition) || this.isButtonJustPressed(buttonBitsDefinition);
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + "/******** Buttons ********/\n";
        out = String.valueOf(out) + "--- Buttons just pressed : " + this.buttonsJustPressed + "\n";
        out = String.valueOf(out) + "--- Buttons just released : " + this.buttonsJustReleased + "\n";
        out = String.valueOf(out) + "--- Buttons held : " + this.buttonsHeld + "\n";
        return out;
    }
}

