/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import wiiusej.values.GForce;
import wiiusej.wiiusejevents.GenericEvent;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public abstract class GForcePanel
extends JPanel
implements WiimoteListener {
    private Image mImage;
    private Color xColor = Color.RED;
    private Color yColor = Color.GREEN;
    private Color zColor = Color.BLUE;
    private Color backgroundColor = Color.WHITE;
    private Color lineColor = Color.BLACK;
    private ArrayList<GForce> values = new ArrayList();

    public GForcePanel() {
        this.initComponents();
    }

    public GForcePanel(Color bgColor, Color xxColor, Color yyColor, Color zzColor, Color lColor) {
        this.backgroundColor = bgColor;
        this.xColor = xxColor;
        this.yColor = yyColor;
        this.zColor = zzColor;
        this.lineColor = lColor;
        this.initComponents();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        this.checkOffScreenImage();
        Graphics offG = this.mImage.getGraphics();
        offG.setColor(this.backgroundColor);
        offG.fillRect(0, 0, d.width, d.height);
        Graphics2D g2 = (Graphics2D)this.mImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double yMiddleFloat = (double)this.getHeight() / 2.0;
        int yMiddle = (int)Math.round(yMiddleFloat);
        g2.setPaint(this.lineColor);
        g2.drawLine(0, yMiddle, this.getWidth(), yMiddle);
        GForce[] valuesArray = this.values.toArray(new GForce[0]);
        double unit = yMiddleFloat / 5.0;
        int previousX = 0;
        int previousY = 0;
        int previousZ = 0;
        int i = 0;
        while (i < valuesArray.length && i < this.getWidth()) {
            GForce gforce = valuesArray[i];
            g2.setPaint(this.xColor);
            int yDelta = (int)Math.round(unit * (double)gforce.getX());
            int y = -1 * yDelta + yMiddle;
            g2.drawLine(i - 1, previousX, i, y);
            g2.setTransform(new AffineTransform());
            previousX = y;
            g2.setPaint(this.yColor);
            yDelta = (int)Math.round(unit * (double)gforce.getY());
            y = -1 * yDelta + yMiddle;
            g2.drawLine(i - 1, previousY, i, y);
            g2.setTransform(new AffineTransform());
            previousY = y;
            g2.setPaint(this.zColor);
            yDelta = (int)Math.round(unit * (double)gforce.getZ());
            y = -1 * yDelta + yMiddle;
            g2.drawLine(i - 1, previousZ, i, y);
            g2.setTransform(new AffineTransform());
            previousZ = y;
            ++i;
        }
        g2.setPaint(this.xColor);
        g2.drawLine(5, this.getHeight() - 10, 25, this.getHeight() - 10);
        g2.setPaint(this.yColor);
        g2.drawLine(60, this.getHeight() - 10, 80, this.getHeight() - 10);
        g2.setPaint(this.zColor);
        g2.drawLine(120, this.getHeight() - 10, 140, this.getHeight() - 10);
        g2.setPaint(this.lineColor);
        g2.drawString("X", 30, this.getHeight() - 5);
        g2.drawString("Y", 85, this.getHeight() - 5);
        g2.drawString("Z", 145, this.getHeight() - 5);
        g2.drawString("0", 2, yMiddle - 5);
        g2.drawString("5", 2, 10);
        g2.drawString("-5", 2, this.getHeight() - 15);
        g.drawImage(this.mImage, 0, 0, null);
    }

    private void checkOffScreenImage() {
        Dimension d = this.getSize();
        if (this.mImage == null || this.mImage.getWidth(null) != d.width || this.mImage.getHeight(null) != d.height) {
            this.mImage = this.createImage(d.width, d.height);
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
    }

    public void onIrEvent(IREvent arg0) {
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
        this.draw(arg0);
    }

    public void onExpansionEvent(ExpansionEvent arg0) {
        this.draw(arg0);
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
        this.values.clear();
        this.repaint();
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent arg0) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent arg0) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
    }

    private void draw(GenericEvent arg0) {
        GForce gforce;
        if (this.values.size() >= this.getWidth()) {
            this.values.clear();
        }
        if ((gforce = this.getGForceValue(arg0)) != null) {
            this.values.add(gforce);
        }
        this.repaint();
    }

    public abstract GForce getGForceValue(GenericEvent var1);

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getXColor() {
        return this.xColor;
    }

    public Color getYColor() {
        return this.yColor;
    }

    public Color getZColor() {
        return this.zColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setXColor(Color xColor) {
        this.xColor = xColor;
    }

    public void setYColor(Color yColor) {
        this.yColor = yColor;
    }

    public void setZColor(Color zColor) {
        this.zColor = zColor;
    }

    public void clearView() {
        this.values.clear();
        this.repaint();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

