/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public class ButtonsEventPanel
extends JPanel
implements WiimoteListener {
    private Image mImage;
    private Image wiimoteImage;
    private WiimoteButtonsEvent buttons;
    private Color pressedColor = Color.RED;
    private Color heldColor = Color.ORANGE;
    private Color releasedColor = Color.YELLOW;
    private Shape shape = new Ellipse2D.Double(0.0, 0.0, 13.0, 13.0);

    public ButtonsEventPanel() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL url = ButtonsEventPanel.class.getResource("/img/wiimote.png");
        this.wiimoteImage = toolkit.createImage(url);
        this.initComponents();
    }

    public ButtonsEventPanel(Color pressColor, Color hColor, Color relColor, Shape sh) {
        this.pressedColor = pressColor;
        this.heldColor = hColor;
        this.releasedColor = relColor;
        this.shape = sh;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.wiimoteImage = toolkit.createImage("img\\wiimote.png");
        this.initComponents();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        this.checkOffScreenImage();
        Graphics offG = this.mImage.getGraphics();
        offG.fillRect(0, 0, d.width, d.height);
        Graphics2D g2 = (Graphics2D)this.mImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(this.wiimoteImage, 0, 0, this);
        g2.setTransform(new AffineTransform());
        if (this.buttons != null) {
            if (this.buttons.isButtonOneJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 53, 353);
            }
            if (this.buttons.isButtonOneHeld()) {
                this.drawFunction(g2, this.heldColor, 53, 353);
            }
            if (this.buttons.isButtonOneJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 53, 353);
            }
            if (this.buttons.isButtonTwoJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 53, 395);
            }
            if (this.buttons.isButtonTwoHeld()) {
                this.drawFunction(g2, this.heldColor, 53, 395);
            }
            if (this.buttons.isButtonTwoJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 53, 395);
            }
            if (this.buttons.isButtonAJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 53, 150);
            }
            if (this.buttons.isButtonAHeld()) {
                this.drawFunction(g2, this.heldColor, 53, 150);
            }
            if (this.buttons.isButtonAJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 53, 150);
            }
            if (this.buttons.isButtonBJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 16, 149);
            }
            if (this.buttons.isButtonBHeld()) {
                this.drawFunction(g2, this.heldColor, 16, 149);
            }
            if (this.buttons.isButtonBJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 16, 149);
            }
            if (this.buttons.isButtonLeftJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 33, 77);
            }
            if (this.buttons.isButtonLeftHeld()) {
                this.drawFunction(g2, this.heldColor, 33, 77);
            }
            if (this.buttons.isButtonLeftJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 33, 77);
            }
            if (this.buttons.isButtonRightJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 73, 77);
            }
            if (this.buttons.isButtonRightHeld()) {
                this.drawFunction(g2, this.heldColor, 73, 77);
            }
            if (this.buttons.isButtonRightJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 73, 77);
            }
            if (this.buttons.isButtonUpJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 54, 60);
            }
            if (this.buttons.isButtonUpHeld()) {
                this.drawFunction(g2, this.heldColor, 54, 60);
            }
            if (this.buttons.isButtonUpJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 54, 60);
            }
            if (this.buttons.isButtonDownJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 54, 97);
            }
            if (this.buttons.isButtonDownHeld()) {
                this.drawFunction(g2, this.heldColor, 54, 97);
            }
            if (this.buttons.isButtonDownJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 54, 97);
            }
            if (this.buttons.isButtonMinusJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 20, 230);
            }
            if (this.buttons.isButtonMinusHeld()) {
                this.drawFunction(g2, this.heldColor, 20, 230);
            }
            if (this.buttons.isButtonMinusJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 20, 230);
            }
            if (this.buttons.isButtonPlusJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 86, 230);
            }
            if (this.buttons.isButtonPlusHeld()) {
                this.drawFunction(g2, this.heldColor, 86, 230);
            }
            if (this.buttons.isButtonPlusJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 86, 230);
            }
            if (this.buttons.isButtonHomeJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 53, 230);
            }
            if (this.buttons.isButtonHomeHeld()) {
                this.drawFunction(g2, this.heldColor, 53, 230);
            }
            if (this.buttons.isButtonHomeJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 53, 230);
            }
            this.buttons = null;
        }
        g.drawImage(this.mImage, 0, 0, null);
    }

    private void drawFunction(Graphics2D g2, Color col, int x, int y) {
        g2.setPaint(col);
        g2.translate(x, y);
        g2.draw(this.shape);
        g2.fill(this.shape);
        g2.setTransform(new AffineTransform());
    }

    private void checkOffScreenImage() {
        Dimension d = this.getSize();
        if (this.mImage == null || this.mImage.getWidth(null) != d.width || this.mImage.getHeight(null) != d.height) {
            this.mImage = this.createImage(d.width, d.height);
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
        this.setSize(this.wiimoteImage.getWidth(this), this.wiimoteImage.getHeight(this));
        this.buttons = arg0;
        this.repaint();
    }

    public void onIrEvent(IREvent arg0) {
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
    }

    public void onExpansionEvent(ExpansionEvent e) {
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
        this.clearView();
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent e) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent e) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
    }

    public Color getHeldColor() {
        return this.heldColor;
    }

    public Color getPressedColor() {
        return this.pressedColor;
    }

    public Color getReleasedColor() {
        return this.releasedColor;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setHeldColor(Color heldColor) {
        this.heldColor = heldColor;
    }

    public void setPressedColor(Color pressedColor) {
        this.pressedColor = pressedColor;
    }

    public void setReleasedColor(Color releasedColor) {
        this.releasedColor = releasedColor;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void clearView() {
        this.buttons = null;
        this.repaint();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

