/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.test;

import java.awt.AWTException;
import java.awt.Robot;
import wiiusej.WiiUseApiManager;
import wiiusej.Wiimote;
import wiiusej.values.IRSource;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public class Tests
implements WiimoteListener {
    Robot robot;
    private static int DISPLAY_EACH_VALUE = 1;
    private static int DUMP = 2;
    private static int MOVE_MOUSE = 3;
    private static int TEST_LEDS = 5;
    private Wiimote wiimote;
    int dump = DISPLAY_EACH_VALUE;

    public Tests(Wiimote wim) {
        this.wiimote = wim;
        this.wiimote.addWiiMoteEventListeners(this);
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent e) {
        if (this.dump == DISPLAY_EACH_VALUE) {
            if (e.isButtonOneJustPressed()) {
                System.out.println("button one pressed");
            }
            if (e.isButtonOneHeld()) {
                System.out.println("button one held");
            }
            if (e.isButtonOneJustReleased()) {
                System.out.println("button one released");
            }
            if (e.isButtonTwoJustPressed()) {
                System.out.println("button two pressed");
            }
            if (e.isButtonTwoHeld()) {
                System.out.println("button two held");
            }
            if (e.isButtonTwoJustReleased()) {
                System.out.println("button two released");
            }
            if (e.isButtonAJustPressed()) {
                System.out.println("button A pressed");
            }
            if (e.isButtonAHeld()) {
                System.out.println("button A held");
            }
            if (e.isButtonAJustReleased()) {
                System.out.println("button A released");
            }
            if (e.isButtonBJustPressed()) {
                System.out.println("button B pressed");
            }
            if (e.isButtonBHeld()) {
                System.out.println("button B held");
            }
            if (e.isButtonBJustReleased()) {
                System.out.println("button B released");
            }
            if (e.isButtonLeftJustPressed()) {
                System.out.println("button Left pressed");
            }
            if (e.isButtonLeftHeld()) {
                System.out.println("button Left held");
            }
            if (e.isButtonLeftJustReleased()) {
                System.out.println("button Left released");
            }
            if (e.isButtonRightJustPressed()) {
                System.out.println("button Right pressed");
            }
            if (e.isButtonRightHeld()) {
                System.out.println("button Right held");
            }
            if (e.isButtonRightJustReleased()) {
                System.out.println("button Right released");
            }
            if (e.isButtonUpJustPressed()) {
                System.out.println("button UP pressed");
            }
            if (e.isButtonUpHeld()) {
                System.out.println("button UP held");
            }
            if (e.isButtonUpJustReleased()) {
                System.out.println("button UP released");
            }
            if (e.isButtonDownJustPressed()) {
                System.out.println("button DOWN pressed");
            }
            if (e.isButtonDownHeld()) {
                System.out.println("button DOWN held");
            }
            if (e.isButtonDownJustReleased()) {
                System.out.println("button DOWN released");
            }
            if (e.isButtonMinusJustPressed()) {
                System.out.println("button MINUS pressed");
            }
            if (e.isButtonMinusHeld()) {
                System.out.println("button MINUS held");
            }
            if (e.isButtonMinusJustReleased()) {
                System.out.println("button MINUS released");
            }
            if (e.isButtonPlusJustPressed()) {
                System.out.println("button PLUS pressed");
            }
            if (e.isButtonPlusHeld()) {
                System.out.println("button PLUS held");
            }
            if (e.isButtonPlusJustReleased()) {
                System.out.println("button PLUS released");
            }
            if (e.isButtonHomeJustPressed()) {
                System.out.println("button HOME pressed");
            }
            if (e.isButtonHomeHeld()) {
                System.out.println("button HOME held");
            }
            if (e.isButtonHomeJustReleased()) {
                System.out.println("button HOME released");
            }
            if (e.isButtonUpJustPressed()) {
                this.wiimote.getStatus();
            }
            if (e.isButtonOneJustPressed()) {
                System.out.println("Rumble Activated");
                this.wiimote.activateRumble();
            }
            if (e.isButtonTwoJustPressed()) {
                System.out.println("Rumble Deactivated");
                this.wiimote.deactivateRumble();
            }
            if (e.isButtonAJustPressed()) {
                System.out.println("IR Activated");
                this.wiimote.activateIRTRacking();
            }
            if (e.isButtonBJustPressed()) {
                System.out.println("IR Deactivated");
                this.wiimote.deactivateIRTRacking();
            }
            if (e.isButtonPlusJustPressed()) {
                System.out.println("Motion sensing Activated");
                this.wiimote.activateMotionSensing();
            }
            if (e.isButtonMinusJustPressed()) {
                System.out.println("Motion sensing Deactivated");
                this.wiimote.deactivateMotionSensing();
            }
            if (e.isButtonHomeJustPressed()) {
                System.out.println("LEAVING TEST");
                this.wiimote.disconnect();
                WiiUseApiManager.definitiveShutdown();
            }
        } else if (this.dump == DUMP) {
            System.out.println(e);
            if (e.isButtonAJustPressed()) {
                System.out.println("IR, rumble and motion sensing Activated");
                this.wiimote.activateIRTRacking();
                this.wiimote.activateMotionSensing();
                this.wiimote.activateRumble();
            }
            if (e.isButtonBJustPressed()) {
                System.out.println("IR, rumble and motion sensing Deactivated");
                this.wiimote.deactivateIRTRacking();
                this.wiimote.deactivateMotionSensing();
                this.wiimote.deactivateRumble();
            }
            if (e.isButtonHomeJustPressed()) {
                System.out.println("LEAVING TEST");
                this.wiimote.disconnect();
            }
        } else if (this.dump == MOVE_MOUSE) {
            if (e.isButtonOneJustPressed()) {
                System.out.println("IR Activated");
                this.wiimote.activateIRTRacking();
            }
            if (e.isButtonTwoJustPressed()) {
                System.out.println("IR Deactivated");
                this.wiimote.deactivateIRTRacking();
            }
            if (e.isButtonAJustPressed()) {
                this.robot.mousePress(16);
            }
            if (e.isButtonAJustReleased()) {
                this.robot.mouseRelease(16);
            }
            if (e.isButtonBJustPressed()) {
                this.robot.mousePress(8);
            }
            if (e.isButtonBJustReleased()) {
                this.robot.mouseRelease(8);
            }
            if (e.isButtonHomeJustPressed()) {
                System.out.println("LEAVING TEST");
                this.wiimote.disconnect();
            }
        } else if (this.dump == TEST_LEDS) {
            this.wiimote.activateMotionSensing();
            if (e.isButtonUpJustPressed()) {
                this.wiimote.setLeds(true, false, false, false);
            }
            if (e.isButtonDownJustPressed()) {
                this.wiimote.setLeds(false, true, false, false);
            }
            if (e.isButtonLeftJustPressed()) {
                this.wiimote.setLeds(false, false, true, false);
            }
            if (e.isButtonRightJustPressed()) {
                this.wiimote.setLeds(false, false, false, true);
            }
            if (e.isButtonHomeJustPressed()) {
                System.out.println("LEAVING TEST");
                this.wiimote.disconnect();
            }
        }
    }

    public void onIrEvent(IREvent e) {
        if (this.dump == MOVE_MOUSE) {
            IRSource[] list = e.getIRPoints();
            if (list.length > 0) {
                int x1 = list[0].getX();
                int y1 = list[0].getY();
                int mousex = (int)Math.round((double)x1 / 1024.0 * 1280.0);
                int mousey = (int)Math.round((double)y1 / 768.0 * 1024.0);
                this.robot.mouseMove(mousex, mousey);
            }
        } else {
            System.out.println(e);
        }
    }

    public void onMotionSensingEvent(MotionSensingEvent e) {
        System.out.println(e);
    }

    public void onExpansionEvent(ExpansionEvent e) {
        System.out.println(e);
    }

    public void onStatusEvent(StatusEvent e) {
        System.out.println(e);
    }

    public void onDisconnectionEvent(DisconnectionEvent e) {
        System.out.println(" wiimote " + e.getWiimoteId() + "has been disconnected !!");
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent e) {
        System.out.println(e);
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent e) {
        System.out.println(e);
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent e) {
        System.out.println(e);
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent e) {
        System.out.println(e);
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent e) {
        System.out.println(e);
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent e) {
        System.out.println(e);
    }

    public static void main(String[] args) {
        Wiimote[] wiimotes = WiiUseApiManager.getWiimotes(1, true);
        if (wiimotes.length > 0) {
            System.out.println(wiimotes[0]);
            new Tests(wiimotes[0]);
        } else {
            System.out.println("No wiimotes found !!!");
        }
    }
}

