/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import wiiusej.Wiimote;
import wiiusej.utils.AccelerationExpansionEventPanel;
import wiiusej.utils.AccelerationPanel;
import wiiusej.utils.GForceExpansionEventPanel;
import wiiusej.utils.GForcePanel;
import wiiusej.utils.NunchukJoystickEventPanel;
import wiiusej.utils.OrientationExpansionEventPanel;
import wiiusej.utils.OrientationPanel;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.NunchukButtonsEvent;
import wiiusej.wiiusejevents.physicalevents.NunchukEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public class NunchukGuiTest
extends JFrame
implements WiimoteListener {
    private Wiimote wiimote;
    private boolean isThresholdsRequested = true;
    private JButton cButton;
    private JPanel gForcePanel;
    private JPanel joystickEventsPanel;
    private JPanel messagePanel;
    private JLabel messageText;
    private JPanel motionSensingEventsPanel;
    private JTabbedPane motionSensingEventsTabbedPanels;
    private JButton nunchukAccelerationButton;
    private JPanel nunchukAccelerationPanel;
    private JTextField nunchukAccelerationTextField;
    private JPanel nunchukButtonsEventPanel;
    private JButton nunchukOrientationButton;
    private JPanel nunchukOrientationPanel;
    private JTextField nunchukOrientationTextField;
    private JPanel orientationPanel;
    private JPanel rawAccelerationPanel;
    private JPanel setNunchukValuesPanel;
    private JPanel topPanels;
    private JButton zButton;

    public NunchukGuiTest(Wiimote wiimote) {
        this.initComponents();
        this.wiimote = wiimote;
        this.registerListeners();
    }

    private void registerListeners() {
        this.wiimote.addWiiMoteEventListeners(this);
        this.wiimote.addWiiMoteEventListeners((OrientationPanel)this.orientationPanel);
        this.wiimote.addWiiMoteEventListeners((GForcePanel)this.gForcePanel);
        this.wiimote.addWiiMoteEventListeners((AccelerationPanel)this.rawAccelerationPanel);
        this.wiimote.addWiiMoteEventListeners((NunchukJoystickEventPanel)this.joystickEventsPanel);
    }

    public void unRegisterListeners() {
        this.wiimote.removeWiiMoteEventListeners((OrientationPanel)this.orientationPanel);
        this.wiimote.removeWiiMoteEventListeners((GForcePanel)this.gForcePanel);
        this.wiimote.removeWiiMoteEventListeners((AccelerationPanel)this.rawAccelerationPanel);
        this.wiimote.removeWiiMoteEventListeners((NunchukJoystickEventPanel)this.joystickEventsPanel);
        this.wiimote.removeWiiMoteEventListeners(this);
    }

    public void requestThresholdsUpdate() {
        this.isThresholdsRequested = true;
    }

    private void initComponents() {
        this.topPanels = new JPanel();
        this.joystickEventsPanel = new NunchukJoystickEventPanel();
        this.motionSensingEventsPanel = new JPanel();
        this.motionSensingEventsTabbedPanels = new JTabbedPane();
        this.rawAccelerationPanel = new AccelerationExpansionEventPanel();
        this.orientationPanel = new OrientationExpansionEventPanel();
        this.gForcePanel = new GForceExpansionEventPanel();
        this.setNunchukValuesPanel = new JPanel();
        this.nunchukButtonsEventPanel = new JPanel();
        this.cButton = new JButton();
        this.zButton = new JButton();
        this.nunchukOrientationPanel = new JPanel();
        this.nunchukOrientationTextField = new JTextField();
        this.nunchukOrientationButton = new JButton();
        this.nunchukAccelerationPanel = new JPanel();
        this.nunchukAccelerationTextField = new JTextField();
        this.nunchukAccelerationButton = new JButton();
        this.messagePanel = new JPanel();
        this.messageText = new JLabel();
        this.setTitle("WiiuseJ Nunchuk Test GUI");
        this.setMinimumSize(new Dimension(400, 400));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.topPanels.setMinimumSize(new Dimension(400, 200));
        this.topPanels.setPreferredSize(new Dimension(400, 200));
        this.topPanels.setLayout(new BoxLayout(this.topPanels, 2));
        this.joystickEventsPanel.setBackground(new Color(0, 0, 0));
        this.joystickEventsPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(51, 153, 0), 2, true), "Joystick View", 0, 0, new Font("Tahoma", 0, 11), new Color(204, 102, 0)));
        this.joystickEventsPanel.setToolTipText("JoystickEvent");
        this.joystickEventsPanel.setMinimumSize(new Dimension(200, 200));
        GroupLayout joystickEventsPanelLayout = new GroupLayout(this.joystickEventsPanel);
        this.joystickEventsPanel.setLayout(joystickEventsPanelLayout);
        joystickEventsPanelLayout.setHorizontalGroup(joystickEventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 601, Short.MAX_VALUE));
        joystickEventsPanelLayout.setVerticalGroup(joystickEventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 174, Short.MAX_VALUE));
        this.topPanels.add(this.joystickEventsPanel);
        this.joystickEventsPanel.getAccessibleContext().setAccessibleName("Joystick");
        this.motionSensingEventsPanel.setMinimumSize(new Dimension(200, 200));
        this.rawAccelerationPanel.setToolTipText("Nunchuk MotionSensingEvent");
        GroupLayout rawAccelerationPanelLayout = new GroupLayout(this.rawAccelerationPanel);
        this.rawAccelerationPanel.setLayout(rawAccelerationPanelLayout);
        rawAccelerationPanelLayout.setHorizontalGroup(rawAccelerationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 597, Short.MAX_VALUE));
        rawAccelerationPanelLayout.setVerticalGroup(rawAccelerationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 175, Short.MAX_VALUE));
        this.motionSensingEventsTabbedPanels.addTab("RawAcceleration", this.rawAccelerationPanel);
        GroupLayout orientationPanelLayout = new GroupLayout(this.orientationPanel);
        this.orientationPanel.setLayout(orientationPanelLayout);
        orientationPanelLayout.setHorizontalGroup(orientationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 597, Short.MAX_VALUE));
        orientationPanelLayout.setVerticalGroup(orientationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 175, Short.MAX_VALUE));
        this.motionSensingEventsTabbedPanels.addTab("Orientation", this.orientationPanel);
        GroupLayout gForcePanelLayout = new GroupLayout(this.gForcePanel);
        this.gForcePanel.setLayout(gForcePanelLayout);
        gForcePanelLayout.setHorizontalGroup(gForcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 597, Short.MAX_VALUE));
        gForcePanelLayout.setVerticalGroup(gForcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 175, Short.MAX_VALUE));
        this.motionSensingEventsTabbedPanels.addTab("GForce", this.gForcePanel);
        GroupLayout motionSensingEventsPanelLayout = new GroupLayout(this.motionSensingEventsPanel);
        this.motionSensingEventsPanel.setLayout(motionSensingEventsPanelLayout);
        motionSensingEventsPanelLayout.setHorizontalGroup(motionSensingEventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.motionSensingEventsTabbedPanels, -1, 602, Short.MAX_VALUE));
        motionSensingEventsPanelLayout.setVerticalGroup(motionSensingEventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.motionSensingEventsTabbedPanels, -1, 200, Short.MAX_VALUE));
        this.topPanels.add(this.motionSensingEventsPanel);
        this.getContentPane().add(this.topPanels);
        this.setNunchukValuesPanel.setMinimumSize(new Dimension(400, 200));
        this.setNunchukValuesPanel.setPreferredSize(new Dimension(400, 200));
        this.setNunchukValuesPanel.setLayout(new BoxLayout(this.setNunchukValuesPanel, 1));
        this.nunchukButtonsEventPanel.setToolTipText("Nunchuk ButtonsEvent");
        this.nunchukButtonsEventPanel.setMinimumSize(new Dimension(100, 100));
        this.nunchukButtonsEventPanel.setPreferredSize(new Dimension(100, 100));
        this.nunchukButtonsEventPanel.setLayout(new BoxLayout(this.nunchukButtonsEventPanel, 2));
        this.cButton.setText("C");
        this.cButton.setMaximumSize(new Dimension(50, 50));
        this.cButton.setMinimumSize(new Dimension(50, 50));
        this.cButton.setPreferredSize(new Dimension(50, 50));
        this.nunchukButtonsEventPanel.add(this.cButton);
        this.zButton.setText("Z");
        this.zButton.setMaximumSize(new Dimension(50, 50));
        this.zButton.setMinimumSize(new Dimension(50, 50));
        this.zButton.setPreferredSize(new Dimension(50, 50));
        this.nunchukButtonsEventPanel.add(this.zButton);
        this.setNunchukValuesPanel.add(this.nunchukButtonsEventPanel);
        this.nunchukOrientationTextField.setPreferredSize(new Dimension(60, 20));
        this.nunchukOrientationPanel.add(this.nunchukOrientationTextField);
        this.nunchukOrientationButton.setText("Set Orientation Threshold");
        this.nunchukOrientationButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                NunchukGuiTest.this.nunchukOrientationButtonMousePressed(evt);
            }
        });
        this.nunchukOrientationPanel.add(this.nunchukOrientationButton);
        this.setNunchukValuesPanel.add(this.nunchukOrientationPanel);
        this.nunchukAccelerationTextField.setPreferredSize(new Dimension(60, 20));
        this.nunchukAccelerationPanel.add(this.nunchukAccelerationTextField);
        this.nunchukAccelerationButton.setText("Set Acceleration Threshold");
        this.nunchukAccelerationButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                NunchukGuiTest.this.nunchukAccelerationButtonMousePressed(evt);
            }
        });
        this.nunchukAccelerationPanel.add(this.nunchukAccelerationButton);
        this.setNunchukValuesPanel.add(this.nunchukAccelerationPanel);
        this.messageText.setText("Message:");
        GroupLayout messagePanelLayout = new GroupLayout(this.messagePanel);
        this.messagePanel.setLayout(messagePanelLayout);
        messagePanelLayout.setHorizontalGroup(messagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1216, Short.MAX_VALUE).addGroup(messagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(messagePanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.messageText).addGap(0, 0, Short.MAX_VALUE))));
        messagePanelLayout.setVerticalGroup(messagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 34, Short.MAX_VALUE).addGroup(messagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(messagePanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.messageText).addGap(0, 0, Short.MAX_VALUE))));
        this.setNunchukValuesPanel.add(this.messagePanel);
        this.getContentPane().add(this.setNunchukValuesPanel);
        this.pack();
    }

    private void nunchukOrientationButtonMousePressed(MouseEvent evt) {
        try {
            float nb = Float.parseFloat(this.nunchukOrientationTextField.getText());
            this.wiimote.setNunchukOrientationThreshold(nb);
            this.messageText.setText("Nunchuk orientation threshold set to " + nb);
        }
        catch (NumberFormatException e) {
            this.messageText.setText("Number is not an integer, nunchuk orientation threshold not set !");
        }
    }

    private void nunchukAccelerationButtonMousePressed(MouseEvent evt) {
        try {
            int nb = Integer.parseInt(this.nunchukAccelerationTextField.getText());
            this.wiimote.setNunchukAccelerationThreshold(nb);
            this.messageText.setText("Nunchuk acceleration threshold set to " + nb);
        }
        catch (NumberFormatException e) {
            this.messageText.setText("Number is not an integer, nunchuk acceleration threshold not set !");
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
    }

    public void onIrEvent(IREvent arg0) {
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
    }

    public void onExpansionEvent(ExpansionEvent arg0) {
        if (arg0 instanceof NunchukEvent) {
            NunchukEvent nunchuk = (NunchukEvent)arg0;
            NunchukButtonsEvent buttons = nunchuk.getButtonsEvent();
            if (buttons.isButtonCJustPressed()) {
                this.cButton.setEnabled(false);
            } else if (buttons.isButtonCJustReleased()) {
                this.cButton.setEnabled(true);
            }
            if (buttons.isButtonZJustPressed()) {
                this.zButton.setEnabled(false);
            } else if (buttons.isButtonZJustReleased()) {
                this.zButton.setEnabled(true);
            }
            if (this.isThresholdsRequested) {
                MotionSensingEvent evt = nunchuk.getNunchukMotionSensingEvent();
                this.nunchukAccelerationTextField.setText(String.valueOf(evt.getAccelerationThreshold()));
                this.nunchukOrientationTextField.setText(String.valueOf(evt.getOrientationThreshold()));
                this.isThresholdsRequested = false;
            }
        }
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent arg0) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent arg0) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
    }
}

