/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.test;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import wiiusej.WiiUseApiManager;
import wiiusej.Wiimote;
import wiiusej.utils.ClassicControllerButtonsEventPanel;
import wiiusej.wiiusejevents.physicalevents.ClassicControllerEvent;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public class ClassicControllerGuiTest
extends JFrame
implements WiimoteListener {
    private Wiimote wiimote;
    private static int MAX_SHOULDER = 100;
    private JPanel classicControllerPanel;
    private JProgressBar leftShoulderBar;
    private JProgressBar rightShoulderBar;
    private JPanel shouldersPanel;

    public ClassicControllerGuiTest(Wiimote wiimote) {
        this.initComponents();
        this.wiimote = wiimote;
        this.registerListeners();
        this.leftShoulderBar.setMaximum(MAX_SHOULDER);
        this.rightShoulderBar.setMaximum(MAX_SHOULDER);
    }

    private void registerListeners() {
        this.wiimote.addWiiMoteEventListeners(this);
        this.wiimote.addWiiMoteEventListeners((ClassicControllerButtonsEventPanel)this.classicControllerPanel);
    }

    public void unRegisterListeners() {
        this.wiimote.removeWiiMoteEventListeners(this);
        this.wiimote.removeWiiMoteEventListeners((ClassicControllerButtonsEventPanel)this.classicControllerPanel);
    }

    private void initComponents() {
        this.shouldersPanel = new JPanel();
        this.leftShoulderBar = new JProgressBar();
        this.rightShoulderBar = new JProgressBar();
        this.classicControllerPanel = new ClassicControllerButtonsEventPanel();
        this.setTitle("WiiuseJ Classic Controller Test GUI");
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.shouldersPanel.setMaximumSize(new Dimension(350, 16));
        this.shouldersPanel.setMinimumSize(new Dimension(350, 16));
        this.shouldersPanel.setPreferredSize(new Dimension(350, 16));
        this.shouldersPanel.setLayout(new BoxLayout(this.shouldersPanel, 2));
        this.shouldersPanel.add(this.leftShoulderBar);
        this.shouldersPanel.add(this.rightShoulderBar);
        this.getContentPane().add(this.shouldersPanel);
        this.classicControllerPanel.setMaximumSize(new Dimension(350, 182));
        this.classicControllerPanel.setMinimumSize(new Dimension(350, 182));
        GroupLayout classicControllerPanelLayout = new GroupLayout(this.classicControllerPanel);
        this.classicControllerPanel.setLayout(classicControllerPanelLayout);
        classicControllerPanelLayout.setHorizontalGroup(classicControllerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        classicControllerPanelLayout.setVerticalGroup(classicControllerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 182, Short.MAX_VALUE));
        this.getContentPane().add(this.classicControllerPanel);
        this.pack();
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
    }

    public void onIrEvent(IREvent arg0) {
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
    }

    public void onExpansionEvent(ExpansionEvent arg0) {
        if (arg0 instanceof ClassicControllerEvent) {
            ClassicControllerEvent classicController = (ClassicControllerEvent)arg0;
            float leftShoulder = classicController.getLeftShoulder();
            float rightShoulder = classicController.getRightShoulder();
            this.leftShoulderBar.setValue(Math.round(leftShoulder * (float)MAX_SHOULDER));
            this.rightShoulderBar.setValue(Math.round(rightShoulder * (float)MAX_SHOULDER));
        }
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent arg0) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent arg0) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
    }

    public static void main(String[] args) {
        Wiimote[] wiimotes = WiiUseApiManager.getWiimotes(1, true);
        JFrame gui = null;
        if (wiimotes.length > 0) {
            gui = new ClassicControllerGuiTest(wiimotes[0]);
        }
        gui.setDefaultCloseOperation(3);
        gui.setVisible(true);
    }
}

