/*
 * Decompiled with CFR 0.152.
 */
package wiiusej;

import javax.swing.event.EventListenerList;
import wiiusej.WiiUseApiManager;
import wiiusej.wiiusejevents.utils.WiiUseApiListener;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;
import wiiusej.wiiusejevents.wiiuseapievents.WiiUseApiEvent;
import wiiusej.wiiusejevents.wiiuseapievents.WiimoteEvent;

public class Wiimote
implements WiiUseApiListener {
    private int id = -1;
    private EventListenerList listeners = new EventListenerList();
    private WiiUseApiManager manager;

    public Wiimote(int idd, WiiUseApiManager manager) {
        this.id = idd;
        this.manager = manager;
    }

    public int getId() {
        return this.id;
    }

    public void disconnect() {
        this.deactivateIRTRacking();
        this.deactivateMotionSensing();
        this.deactivateRumble();
        this.manager.closeConnection(this.id);
    }

    public void activateRumble() {
        this.manager.activateRumble(this.id);
    }

    public void deactivateRumble() {
        this.manager.deactivateRumble(this.id);
    }

    public void activateIRTRacking() {
        this.manager.activateIRTRacking(this.id);
    }

    public void deactivateIRTRacking() {
        this.manager.deactivateIRTRacking(this.id);
    }

    public void activateMotionSensing() {
        this.manager.activateMotionSensing(this.id);
    }

    public void deactivateMotionSensing() {
        this.manager.deactivateMotionSensing(this.id);
    }

    public void activateSmoothing() {
        this.manager.activateSmoothing(this.id);
    }

    public void deactivateSmoothing() {
        this.manager.deactivateSmoothing(this.id);
    }

    public void activateContinuous() {
        this.manager.activateContinuous(this.id);
    }

    public void deactivateContinuous() {
        this.manager.deactivateContinuous(this.id);
    }

    public void setLeds(boolean l1, boolean l2, boolean l3, boolean l4) {
        this.manager.setLeds(this.id, l1, l2, l3, l4);
    }

    public void setOrientationThreshold(float th) {
        this.manager.setOrientationThreshold(this.id, th);
    }

    public void setAccelerationThreshold(int th) {
        this.manager.setAccelerationThreshold(this.id, th);
    }

    public void setAlphaSmoothingValue(float th) {
        this.manager.setAlphaSmoothing(this.id, th);
    }

    public void setScreenAspectRatio43() {
        this.manager.setScreenAspectRatio43(this.id);
    }

    public void setScreenAspectRatio169() {
        this.manager.setScreenAspectRatio169(this.id);
    }

    public void setSensorBarAboveScreen() {
        this.manager.setSensorBarAboveScreen(this.id);
    }

    public void setSensorBarBelowScreen() {
        this.manager.setSensorBarBelowScreen(this.id);
    }

    public void setVirtualResolution(int x, int y) {
        this.manager.setVirtualResolution(this.id, x, y);
    }

    public void setNunchukOrientationThreshold(float th) {
        this.manager.setNunchukOrientationThreshold(this.id, th);
    }

    public void setNunchukAccelerationThreshold(int th) {
        this.manager.setNunchukAccelerationThreshold(this.id, th);
    }

    public void reSync() {
        this.manager.reSync(this.id);
    }

    public void getStatus() {
        this.manager.getStatus(this.id);
    }

    public void setTimeout(short normalTimeout, short expansionTimeout) {
        this.manager.setTimeout(this.id, normalTimeout, expansionTimeout);
    }

    public void setIrSensitivity(int level) {
        this.manager.setIrSensitivity(this.id, level);
    }

    public void onWiiUseApiEvent(WiiUseApiEvent e) {
        if (e.getWiimoteId() == this.id) {
            if (e.getEventType() == WiiUseApiEvent.GENERIC_EVENT) {
                this.notifyWiiMoteEventListeners((WiimoteEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.STATUS_EVENT) {
                this.notifyStatusEventListeners((StatusEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.DISCONNECTION_EVENT) {
                this.notifyDisconnectionEventListeners((DisconnectionEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.WIIUSE_NUNCHUK_INSERTED) {
                this.notifyNunchukInsertedEventListeners((NunchukInsertedEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.WIIUSE_NUNCHUK_REMOVED) {
                this.notifyNunchukRemovedEventListeners((NunchukRemovedEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.WIIUSE_GUITAR_HERO_3_CTRL_INSERTED) {
                this.notifyGuitarHeroInsertedEventListeners((GuitarHeroInsertedEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.WIIUSE_GUITAR_HERO_3_CTRL_REMOVED) {
                this.notifyGuitarHeroRemovedEventListeners((GuitarHeroRemovedEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.WIIUSE_CLASSIC_CTRL_INSERTED) {
                this.notifyClassicControllerInsertedEventListeners((ClassicControllerInsertedEvent)e);
            } else if (e.getEventType() == WiiUseApiEvent.WIIUSE_CLASSIC_CTRL_REMOVED) {
                this.notifyClassicControllerRemovedEventListeners((ClassicControllerRemovedEvent)e);
            }
        }
    }

    public void addWiiMoteEventListeners(WiimoteListener listener) {
        this.listeners.add(WiimoteListener.class, listener);
    }

    public void removeWiiMoteEventListeners(WiimoteListener listener) {
        this.listeners.remove(WiimoteListener.class, listener);
    }

    public WiimoteListener[] getWiiMoteEventListeners() {
        return (WiimoteListener[])this.listeners.getListeners(WiimoteListener.class);
    }

    private void notifyWiiMoteEventListeners(WiimoteEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onButtonsEvent(evt.getButtonsEvent());
            if (evt.isThereIrEvent()) {
                listener.onIrEvent(evt.getIREvent());
            }
            if (evt.isThereMotionSensingEvent()) {
                listener.onMotionSensingEvent(evt.getMotionSensingEvent());
            }
            if (evt.isThereExpansionEvent()) {
                listener.onExpansionEvent(evt.getExpansionEvent());
            }
            ++n2;
        }
    }

    private void notifyStatusEventListeners(StatusEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onStatusEvent(evt);
            ++n2;
        }
    }

    private void notifyDisconnectionEventListeners(DisconnectionEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onDisconnectionEvent(evt);
            ++n2;
        }
    }

    private void notifyNunchukInsertedEventListeners(NunchukInsertedEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onNunchukInsertedEvent(evt);
            ++n2;
        }
    }

    private void notifyNunchukRemovedEventListeners(NunchukRemovedEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onNunchukRemovedEvent(evt);
            ++n2;
        }
    }

    private void notifyGuitarHeroInsertedEventListeners(GuitarHeroInsertedEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onGuitarHeroInsertedEvent(evt);
            ++n2;
        }
    }

    private void notifyGuitarHeroRemovedEventListeners(GuitarHeroRemovedEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onGuitarHeroRemovedEvent(evt);
            ++n2;
        }
    }

    private void notifyClassicControllerInsertedEventListeners(ClassicControllerInsertedEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onClassicControllerInsertedEvent(evt);
            ++n2;
        }
    }

    private void notifyClassicControllerRemovedEventListeners(ClassicControllerRemovedEvent evt) {
        WiimoteListener[] wiimoteListenerArray = this.getWiiMoteEventListeners();
        int n = wiimoteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiimoteListener listener = wiimoteListenerArray[n2];
            listener.onClassicControllerRemovedEvent(evt);
            ++n2;
        }
    }

    public String toString() {
        return "Wiimote with ID : " + this.id;
    }
}

