/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vietocr;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;

public class ImageHelper {
    private static final short[] invertTable = new short[256];

    public static BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage getSubImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        int n5 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, n5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage.getSubimage(n, n2, n3, n4), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage convertImageToBinary(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Deprecated
    public static BufferedImage convertImage2Binary(BufferedImage bufferedImage) {
        return ImageHelper.convertImageToBinary(bufferedImage);
    }

    public static BufferedImage convertImageToGrayscale(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage invertImageColor(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        LookupOp lookupOp = new LookupOp(new ShortLookupTable(0, invertTable), null);
        return lookupOp.filter(bufferedImage, bufferedImage2);
    }

    public static BufferedImage rotateImage(BufferedImage bufferedImage, double d) {
        double d2 = Math.toRadians(d);
        double d3 = Math.abs(Math.sin(d2));
        double d4 = Math.abs(Math.cos(d2));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = (int)Math.floor((double)n * d4 + (double)n2 * d3);
        int n4 = (int)Math.floor((double)n2 * d4 + (double)n * d3);
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.translate((n3 - n) / 2, (n4 - n2) / 2);
        graphics2D.rotate(d2, n / 2, n2 / 2);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static Image getClipboardImage() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            return (Image)clipboard.getData(DataFlavor.imageFlavor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ImageHelper.invertTable[i] = (short)(255 - i);
        }
    }
}

