/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl.textures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.saintandreas.resources.Images;
import org.saintandreas.resources.Resource;

public class Texture {
    public final int id = GL11.glGenTextures();
    private final int target;

    public Texture(int target) {
        this.target = target;
    }

    public Texture() {
        this(3553);
    }

    public void bind() {
        GL11.glBindTexture((int)this.target, (int)this.id);
    }

    public void unbind() {
        Texture.unbind(this.target);
    }

    public static void unbind(int target) {
        GL11.glBindTexture((int)target, (int)0);
    }

    public void parameter(int pname, int value) {
        GL11.glTexParameteri((int)this.target, (int)pname, (int)value);
    }

    public void parameter(int pname, float value) {
        GL11.glTexParameterf((int)this.target, (int)pname, (float)value);
    }

    public void image2d(int internalformat, int width, int height, int format, int type, ByteBuffer pixels) {
        GL11.glTexImage2D((int)this.target, (int)0, (int)internalformat, (int)width, (int)height, (int)0, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public void loadImageData(BufferedImage image, int loadTarget) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -image.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        image = op.filter(image, null);
        GL11.glTexImage2D((int)loadTarget, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)Texture.convertImageData(image));
    }

    public static Texture loadImage(BufferedImage image, int textureType, int loadTarget) {
        Texture result = new Texture(textureType);
        result.bind();
        result.loadImageData(image, loadTarget);
        result.unbind();
        return result;
    }

    public static Texture loadImage(Resource r, int textureType, int loadTarget) {
        return Texture.loadImage(Images.load((Resource)r), textureType, loadTarget);
    }

    public static Texture loadImage(URL url, int textureType, int loadTarget) {
        return Texture.loadImage(Images.load((URL)url), textureType, loadTarget);
    }

    public static Texture loadImage(BufferedImage image, int textureType) {
        return Texture.loadImage(image, textureType, textureType);
    }

    public static Texture loadImage(Resource r, int textureType) throws IOException {
        return Texture.loadImage(r, textureType, textureType);
    }

    public static Texture loadImage(URL url, int textureType) throws IOException {
        return Texture.loadImage(url, textureType, textureType);
    }

    public static Texture loadImage(BufferedImage image) {
        return Texture.loadImage(image, 3553);
    }

    public static Texture loadImage(Resource r) throws IOException {
        return Texture.loadImage(r, 3553);
    }

    public static Texture loadImage(URL url) throws IOException {
        return Texture.loadImage(url, 3553);
    }

    public static ByteBuffer convertImageData(BufferedImage bufferedImage) {
        ComponentColorModel glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, bufferedImage.getWidth(), bufferedImage.getHeight(), 4, null);
        BufferedImage texImage = new BufferedImage(glAlphaColorModel, raster, true, new Hashtable());
        Graphics g = texImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        g.drawImage(bufferedImage, 0, 0, null);
        byte[] data = ((DataBufferByte)texImage.getRaster().getDataBuffer()).getData();
        BufferUtils.createByteBuffer((int)data.length);
        ByteBuffer imageBuffer = ByteBuffer.allocateDirect(data.length);
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(data, 0, data.length);
        imageBuffer.flip();
        return imageBuffer;
    }
}

