/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl;

import com.google.common.collect.Lists;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Measure;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL31;
import org.saintandreas.gl.BufferUtils;
import org.saintandreas.gl.Colors;
import org.saintandreas.gl.GlamourResources;
import org.saintandreas.gl.IndexedGeometry;
import org.saintandreas.gl.MatrixStack;
import org.saintandreas.gl.buffers.IndexBuffer;
import org.saintandreas.gl.buffers.VertexArray;
import org.saintandreas.gl.buffers.VertexBuffer;
import org.saintandreas.gl.shaders.Attribute;
import org.saintandreas.gl.shaders.Program;
import org.saintandreas.gl.textures.Texture;
import org.saintandreas.math.Matrix4f;
import org.saintandreas.math.Vector2f;
import org.saintandreas.math.Vector3f;
import org.saintandreas.math.Vector4f;
import org.saintandreas.resources.Images;
import org.saintandreas.resources.Resource;

public final class OpenGL {
    public static IndexedGeometry COLOR_CUBE = null;
    private static final float TAU = (float)Math.PI * 2;
    private static final Map<Resource, Texture> CUBE_MAPS = new HashMap<Resource, Texture>();
    private static final int[] RESOURCE_ORDER = new int[]{34070, 34069, 34072, 34071, 34074, 34073};
    private static final FloatBuffer MATRIX_FLOAT_BUFFER = BufferUtils.getFloatBuffer(16);
    private static IndexedGeometry COLOR_CUBE_GEOMETRY = null;
    private static Program COLOR_CUBE_PROGRAM = null;

    private OpenGL() {
    }

    public static void checkError() {
        int error = GL11.glGetError();
        if (error != 0) {
            // empty if block
        }
    }

    public static FloatBuffer toFloatBuffer(Matrix4f matrix) {
        FloatBuffer buffer = BufferUtils.getFloatBuffer(16);
        matrix.fillFloatBuffer(buffer);
        buffer.position(0);
        return buffer;
    }

    public static List<Vector4f> makeQuad(float size) {
        return OpenGL.makeQuad(new Vector2f(size, size));
    }

    public static List<Vector4f> makeQuad(Vector2f size) {
        Vector2f max = (Vector2f)size.mult(0.5f);
        Vector2f min = (Vector2f)max.mult(-1.0f);
        return OpenGL.makeQuad(min, max);
    }

    public static List<Vector4f> makeQuad(Vector2f min, Vector2f max) {
        ArrayList<Vector4f> result = new ArrayList<Vector4f>(4);
        result.add(new Vector4f(min.x, min.y, 0.0f, 1.0f));
        result.add(new Vector4f(max.x, min.y, 0.0f, 1.0f));
        result.add(new Vector4f(min.x, max.y, 0.0f, 1.0f));
        result.add(new Vector4f(max.x, max.y, 0.0f, 1.0f));
        return result;
    }

    public static List<Vector4f> transformed(Collection<Vector4f> vs, Matrix4f m) {
        ArrayList<Vector4f> result = new ArrayList<Vector4f>(vs.size());
        for (Vector4f v : vs) {
            result.add(m.mult(v));
        }
        return result;
    }

    public static List<Vector4f> interleaveConstants(Collection<? extends Vector4f> vs, Vector4f ... attributes) {
        ArrayList<Vector4f> result = new ArrayList<Vector4f>(vs.size() * (attributes.length + 1));
        for (Vector4f vector4f : vs) {
            result.add(vector4f);
            for (Vector4f a : attributes) {
                result.add(a);
            }
        }
        return result;
    }

    public static IndexedGeometry makeColorCube() {
        if (null == COLOR_CUBE) {
            List<Vector4f> vertices = OpenGL.makeColorCubeVertices();
            List<Short> indices = OpenGL.makeColorCubeIndices();
            IndexedGeometry.Builder builder = new IndexedGeometry.Builder(indices, vertices);
            builder.withDrawType(5).withAttribute(Attribute.POSITION).withAttribute(Attribute.COLOR);
            COLOR_CUBE = builder.build();
        }
        return COLOR_CUBE;
    }

    protected static List<Short> makeColorCubeIndices() {
        ArrayList<Short> result = new ArrayList<Short>();
        int offset = 0;
        for (int i = 0; i < 6; ++i) {
            if (!result.isEmpty()) {
                result.add((short)Short.MAX_VALUE);
            }
            result.addAll(Lists.newArrayList((Object[])new Short[]{(short)(offset + 0), (short)(offset + 1), (short)(offset + 2), (short)(offset + 3)}));
            offset = (short)(offset + 4);
        }
        return result;
    }

    protected static List<Vector4f> makeColorCubeVertices() {
        ArrayList<Vector4f> result = new ArrayList<Vector4f>(48);
        List<Vector4f> q = OpenGL.makeQuad(1.0f);
        Matrix4f m = new Matrix4f().translate(new Vector3f(0.0f, 0.0f, 0.5f));
        result.addAll(OpenGL.interleaveConstants(OpenGL.transformed(q, m), Colors.B));
        m = new Matrix4f().rotate((float)Math.PI, Vector3f.UNIT_X).translate(new Vector3f(0.0f, 0.0f, 0.5f));
        result.addAll(OpenGL.interleaveConstants(OpenGL.transformed(q, m), Colors.Y));
        m = new Matrix4f().rotate(-1.5707964f, Vector3f.UNIT_X).translate(new Vector3f(0.0f, 0.0f, 0.5f));
        result.addAll(OpenGL.interleaveConstants(OpenGL.transformed(q, m), Colors.G));
        m = new Matrix4f().rotate(1.5707964f, Vector3f.UNIT_X).translate(new Vector3f(0.0f, 0.0f, 0.5f));
        result.addAll(OpenGL.interleaveConstants(OpenGL.transformed(q, m), Colors.M));
        m = new Matrix4f().rotate(-1.5707964f, Vector3f.UNIT_Y).translate(new Vector3f(0.0f, 0.0f, 0.5f));
        result.addAll(OpenGL.interleaveConstants(OpenGL.transformed(q, m), Colors.R));
        m = new Matrix4f().rotate(1.5707964f, Vector3f.UNIT_Y).translate(new Vector3f(0.0f, 0.0f, 0.5f));
        result.addAll(OpenGL.interleaveConstants(OpenGL.transformed(q, m), Colors.C));
        return result;
    }

    public static VertexBuffer toVertexBuffer(Collection<Vector4f> vertices) {
        FloatBuffer fb = BufferUtils.getFloatBuffer(vertices.size() * 4);
        for (Vector4f v : vertices) {
            v.fillBuffer(fb);
        }
        fb.position(0);
        VertexBuffer result = new VertexBuffer();
        result.bind();
        result.setData(fb);
        VertexBuffer.unbind();
        return result;
    }

    public static IndexBuffer toShortIndexBuffer(Collection<? extends Number> vertices) {
        ShortBuffer fb = BufferUtils.getShortBuffer(vertices.size());
        for (Number number : vertices) {
            fb.put(number.shortValue());
        }
        fb.position(0);
        IndexBuffer result = new IndexBuffer();
        result.bind();
        result.setData(fb);
        IndexBuffer.unbind();
        return result;
    }

    public static IndexBuffer toIntIndexBuffer(Collection<? extends Number> vertices) {
        IntBuffer fb = BufferUtils.getIntBuffer(vertices.size());
        for (Number number : vertices) {
            fb.put(number.intValue());
        }
        fb.position(0);
        IndexBuffer result = new IndexBuffer();
        result.bind();
        result.setData(fb);
        IndexBuffer.unbind();
        return result;
    }

    public static IndexedGeometry makeTexturedQuad(Vector2f min, Vector2f max) {
        return OpenGL.makeTexturedQuad(min, max, new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f));
    }

    public static IndexedGeometry makeTexturedQuad(Vector2f min, Vector2f max, Vector2f tmin, Vector2f tmax) {
        Vector2f texMin = tmin;
        Vector2f texMax = tmax;
        ArrayList<Vector4f> vertices = new ArrayList<Vector4f>();
        vertices.add(new Vector4f(min.x, min.y, 0.0f, 1.0f));
        vertices.add(new Vector4f(texMin.x, texMin.y, 0.0f, 0.0f));
        vertices.add(new Vector4f(max.x, min.y, 0.0f, 1.0f));
        vertices.add(new Vector4f(texMax.x, texMin.y, 0.0f, 0.0f));
        vertices.add(new Vector4f(max.x, max.y, 0.0f, 1.0f));
        vertices.add(new Vector4f(texMax.x, texMax.y, 0.0f, 0.0f));
        vertices.add(new Vector4f(min.x, max.y, 0.0f, 1.0f));
        vertices.add(new Vector4f(texMin.x, texMax.y, 0.0f, 0.0f));
        ArrayList<Short> indices = new ArrayList<Short>();
        indices.add((short)0);
        indices.add((short)1);
        indices.add((short)3);
        indices.add((short)2);
        IndexedGeometry.Builder builder = new IndexedGeometry.Builder(indices, vertices);
        builder.withDrawType(5).withAttribute(Attribute.POSITION).withAttribute(Attribute.TEX);
        return builder.build();
    }

    public static Texture getCubemapTextures(Resource ... resources) {
        assert (resources.length > 0);
        Resource firstResource = resources[0];
        assert (null != firstResource);
        if (!CUBE_MAPS.containsKey(firstResource)) {
            Texture texture = new Texture(34067);
            texture.bind();
            texture.parameter(10240, 9728);
            texture.parameter(10241, 9728);
            texture.parameter(10242, 33071);
            texture.parameter(10243, 33071);
            texture.parameter(32882, 33071);
            for (int i = 0; i < 6 && i < resources.length; ++i) {
                Resource imageResource = resources[i];
                if (null == imageResource) continue;
                int loadTarget = RESOURCE_ORDER[i];
                texture.loadImageData(Images.load((Resource)imageResource), loadTarget);
            }
            texture.unbind();
            CUBE_MAPS.put(firstResource, texture);
        }
        return CUBE_MAPS.get(firstResource);
    }

    public static IndexedGeometry makeTexturedQuad() {
        return OpenGL.makeTexturedQuad(1.0f, (Measure<Float, Length>)Measure.valueOf((float)1.0f, (Unit)SI.METER));
    }

    public static IndexedGeometry makeTexturedQuad(float aspect) {
        return OpenGL.makeTexturedQuad(aspect, (Measure<Float, Length>)Measure.valueOf((float)1.0f, (Unit)SI.METER));
    }

    public static IndexedGeometry makeTexturedQuad(float aspect, Measure<Float, Length> size) {
        float halfSize = Math.abs(size.floatValue(SI.METER)) / 2.0f;
        Vector2f min = new Vector2f(-halfSize, -halfSize / aspect);
        Vector2f max = new Vector2f(halfSize, halfSize / aspect);
        Vector2f texMin = new Vector2f(0.0f, 0.0f);
        Vector2f texMax = new Vector2f(1.0f, 1.0f);
        return OpenGL.makeTexturedQuad(min, max, texMin, texMax);
    }

    public static void bindProjection(Program program) {
        program.setUniform("Projection", MatrixStack.PROJECTION.top());
    }

    public static void bindModelview(Program program) {
        program.setUniform("ModelView", MatrixStack.MODELVIEW.top());
    }

    public static void bindAll(Program program) {
        OpenGL.bindProjection(program);
        OpenGL.bindModelview(program);
    }

    @Deprecated
    public static void bindAll() {
        OpenGL.bindProjection();
        OpenGL.bindModelview();
    }

    @Deprecated
    public static void bindProjection() {
        GL11.glMatrixMode((int)5889);
        OpenGL.loadMatrix(MatrixStack.PROJECTION.top());
    }

    @Deprecated
    public static void bindModelview() {
        GL11.glMatrixMode((int)5888);
        OpenGL.loadMatrix(MatrixStack.MODELVIEW.top());
    }

    @Deprecated
    public static void loadMatrix(Matrix4f m) {
        GL11.glMatrixMode((int)5889);
        MATRIX_FLOAT_BUFFER.rewind();
        m.fillFloatBuffer(MATRIX_FLOAT_BUFFER, true);
        MATRIX_FLOAT_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)MATRIX_FLOAT_BUFFER);
    }

    public static void drawColorCube() {
        GL11.glEnable((int)36765);
        GL31.glPrimitiveRestartIndex((int)Short.MAX_VALUE);
        if (null == COLOR_CUBE_GEOMETRY) {
            COLOR_CUBE_GEOMETRY = OpenGL.makeColorCube();
        }
        if (null == COLOR_CUBE_PROGRAM) {
            COLOR_CUBE_PROGRAM = new Program(GlamourResources.SHADERS_COLORED_VS, GlamourResources.SHADERS_COLORED_FS);
            COLOR_CUBE_PROGRAM.link();
        }
        COLOR_CUBE_PROGRAM.use();
        OpenGL.bindAll(COLOR_CUBE_PROGRAM);
        OpenGL.COLOR_CUBE_GEOMETRY.ibo.bind();
        COLOR_CUBE_GEOMETRY.bindVertexArray();
        COLOR_CUBE_GEOMETRY.draw();
        VertexArray.unbind();
        IndexBuffer.unbind();
        Program.clear();
    }
}

