/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl;

import java.util.List;
import org.lwjgl.opengl.GL11;
import org.saintandreas.gl.Geometry;
import org.saintandreas.gl.OpenGL;
import org.saintandreas.gl.buffers.IndexBuffer;
import org.saintandreas.gl.buffers.VertexArray;
import org.saintandreas.gl.buffers.VertexBuffer;
import org.saintandreas.math.Vector4f;

public class IndexedGeometry
extends Geometry {
    public final IndexBuffer ibo;

    public IndexedGeometry(IndexBuffer ibo, VertexBuffer vbo, VertexArray vao, int drawType, int elements) {
        super(vbo, vao, drawType, elements);
        this.ibo = ibo;
    }

    @Override
    public void bindVertexArray() {
        super.bindVertexArray();
        this.ibo.bind();
    }

    @Override
    public void draw() {
        GL11.glDrawElements((int)this.drawType, (int)this.elements, (int)5125, (long)0L);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ibo.destroy();
    }

    public static class Builder
    extends Geometry.Builder {
        protected final IndexBuffer ibo;

        public Builder(List<? extends Number> indices, List<Vector4f> vertices) {
            this(OpenGL.toIntIndexBuffer(indices), OpenGL.toVertexBuffer(vertices), indices.size());
        }

        public Builder(IndexBuffer ibo, VertexBuffer vbo, int elements) {
            super(vbo, elements);
            this.ibo = ibo;
        }

        @Override
        protected VertexArray buildVertexArray() {
            VertexArray vao = super.buildVertexArray();
            return vao;
        }

        @Override
        public IndexedGeometry build() {
            return new IndexedGeometry(this.ibo, this.vbo, this.buildVertexArray(), this.drawType, this.elements);
        }
    }
}

