/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl;

import java.util.LinkedHashMap;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.saintandreas.gl.buffers.VertexArray;
import org.saintandreas.gl.buffers.VertexBuffer;
import org.saintandreas.gl.shaders.Attribute;

public class Geometry {
    public final VertexBuffer vbo;
    public final VertexArray vao;
    protected final int drawType;
    protected final int elements;

    public Geometry(VertexBuffer vbo, VertexArray vao, int drawType, int elements) {
        this.vbo = vbo;
        this.vao = vao;
        this.drawType = drawType;
        this.elements = elements;
    }

    public void bindVertexArray() {
        this.vao.bind();
    }

    public void draw() {
        GL11.glDrawArrays((int)this.drawType, (int)0, (int)this.elements);
    }

    public VertexBuffer getVertxBuffer() {
        return this.vbo;
    }

    public void destroy() {
        this.vao.destroy();
        this.vbo.destroy();
    }

    public static class Builder {
        protected final VertexBuffer vbo;
        protected int drawType = 4;
        protected final int elements;
        protected final LinkedHashMap<Integer, Integer> attributes = new LinkedHashMap();

        public Builder(VertexBuffer vbo, int elements) {
            this.vbo = vbo;
            this.elements = elements;
        }

        public Builder withDrawType(int drawType) {
            this.drawType = drawType;
            return this;
        }

        public Builder withAttribute(Attribute attribute, int size) {
            this.attributes.put(attribute.location, size);
            return this;
        }

        public Builder withAttribute(Attribute attribute) {
            this.withAttribute(attribute, 16);
            return this;
        }

        public Builder withAttribute(int attribute, int size) {
            this.attributes.put(attribute, size);
            return this;
        }

        public Builder withAttribute(int attribute) {
            this.withAttribute(attribute, 16);
            return this;
        }

        protected VertexArray buildVertexArray() {
            VertexArray vao = new VertexArray();
            vao.bind();
            this.vbo.bind();
            int offset = 0;
            int stride = 0;
            for (Integer size : this.attributes.values()) {
                stride += size.intValue();
            }
            for (Integer location : this.attributes.keySet()) {
                int size = this.attributes.get(location);
                GL20.glEnableVertexAttribArray((int)location);
                GL20.glVertexAttribPointer((int)location, (int)(size >> 2), (int)5126, (boolean)false, (int)stride, (long)offset);
                offset += size;
            }
            VertexArray.unbind();
            VertexBuffer.unbind();
            return vao;
        }

        public Geometry build() {
            return new Geometry(this.vbo, this.buildVertexArray(), this.drawType, this.elements);
        }
    }
}

