/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class BufferUtils {
    public static ByteBuffer getByteBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public static ByteBuffer getByteBuffer() {
        return BufferUtils.getByteBuffer(1);
    }

    public static IntBuffer getIntBuffer(int size) {
        return BufferUtils.getByteBuffer(size * 4).asIntBuffer();
    }

    public static IntBuffer getIntBuffer() {
        return BufferUtils.getIntBuffer(1);
    }

    public static ShortBuffer getShortBuffer(int size) {
        return BufferUtils.getByteBuffer(size * 2).asShortBuffer();
    }

    public static ShortBuffer getShortBuffer() {
        return BufferUtils.getShortBuffer(1);
    }

    public static FloatBuffer getFloatBuffer(int size) {
        return BufferUtils.getByteBuffer(size * 4).asFloatBuffer();
    }

    public static FloatBuffer getFloatBuffer() {
        return BufferUtils.getFloatBuffer(1);
    }
}

