/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.nodyn.NodeProcess;
import io.nodyn.handle.HandleWrap;
import io.nodyn.udp.DatagramChannelInitializer;
import io.nodyn.udp.Family;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class UDPWrap
extends HandleWrap {
    private ChannelFuture channelFuture;
    private InetSocketAddress localAddress;
    private final Bootstrap bootstrap = new Bootstrap();

    public UDPWrap(NodeProcess process) {
        super(process, false);
        ((Bootstrap)this.bootstrap.group(this.process.getEventLoop().getEventLoopGroup())).handler((ChannelHandler)new DatagramChannelInitializer(this));
    }

    public Object bind(String address, int port, int flags, final Family family) throws InterruptedException {
        try {
            InetAddress addr = null;
            addr = family == Family.IPv6 ? Inet6Address.getByName(address) : Inet4Address.getByName(address);
            this.localAddress = new InetSocketAddress(addr, port);
            this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)(flags != 0 ? 1 : 0));
            this.bootstrap.channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                public Channel newChannel() {
                    return new NioDatagramChannel(family == Family.IPv4 ? InternetProtocolFamily.IPv4 : InternetProtocolFamily.IPv6);
                }
            });
            this.channelFuture = ((Bootstrap)this.bootstrap.localAddress((SocketAddress)this.localAddress)).bind();
            this.channelFuture.sync();
        }
        catch (Exception e) {
            return e;
        }
        this.ref();
        return null;
    }

    public Object send(ByteBuf buf, int offset, int length, int port, String address, Family family) {
        try {
            InetSocketAddress remoteAddress = family == Family.IPv4 ? new InetSocketAddress(Inet4Address.getByName(address), port) : new InetSocketAddress(Inet6Address.getByName(address), port);
            DatagramPacket packet = new DatagramPacket((ByteBuf)ReferenceCountUtil.retain((Object)buf.slice(offset, length)), remoteAddress, this.localAddress);
            this.channelFuture.channel().writeAndFlush((Object)packet);
        }
        catch (UnknownHostException e) {
            this.process.getNodyn().handleThrowable(e);
            return e;
        }
        return null;
    }

    public void recvStart() throws Exception {
        this.channelFuture.channel().config().setAutoRead(true);
    }

    public void recvStop() {
        this.channelFuture.channel().config().setAutoRead(false);
    }

    public void setBroadcast(int arg) {
        this.setChannelOption(ChannelOption.SO_BROADCAST, arg == 1);
    }

    public void setTTL(int arg) {
        this.setChannelOption(ChannelOption.IP_MULTICAST_TTL, arg);
    }

    public void setMulticastTTL(int arg) {
        this.setChannelOption(ChannelOption.IP_MULTICAST_TTL, arg);
    }

    public void setMulticastLoopback(int arg) {
        this.setChannelOption(ChannelOption.IP_MULTICAST_LOOP_DISABLED, arg == 1);
    }

    public void addMembership(String mcastAddr, String ifaceAddr) throws UnknownHostException, SocketException {
        InetAddress addr = InetAddress.getByName(mcastAddr);
        if (ifaceAddr == null) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface candidate = ifaces.nextElement();
                if (!candidate.supportsMulticast() || !candidate.isUp()) continue;
                ((DatagramChannel)this.channelFuture.channel()).joinGroup(addr, candidate, null);
            }
        } else {
            NetworkInterface iface = NetworkInterface.getByInetAddress(InetAddress.getByName(ifaceAddr));
            ((DatagramChannel)this.channelFuture.channel()).joinGroup(addr, iface, null);
        }
    }

    public void dropMembership(String mcastAddr, String ifaceAddr) throws UnknownHostException, SocketException {
        InetAddress addr = InetAddress.getByName(mcastAddr);
        if (ifaceAddr == null) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface candidate = ifaces.nextElement();
                if (!candidate.supportsMulticast() || !candidate.isUp()) continue;
                ((DatagramChannel)this.channelFuture.channel()).leaveGroup(addr, candidate, null);
            }
        } else {
            NetworkInterface iface = NetworkInterface.getByInetAddress(InetAddress.getByName(ifaceAddr));
            ((DatagramChannel)this.channelFuture.channel()).leaveGroup(addr, iface, null);
        }
    }

    @Override
    public void close() {
        if (this.channelFuture != null && this.channelFuture.channel() != null) {
            this.channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        super.close();
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getRemoteAddress() {
        return this.channelFuture.channel().remoteAddress();
    }

    private void setChannelOption(ChannelOption option, Object value) {
        if (this.channelFuture != null) {
            this.channelFuture.channel().config().setOption(option, value);
        } else {
            this.bootstrap.option(option, value);
        }
    }
}

