/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.tls;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.nodyn.CallbackResult;
import io.nodyn.NodeProcess;
import io.nodyn.async.AsyncWrap;
import io.nodyn.crypto.SecureContext;
import io.nodyn.stream.StreamWrap;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;

public class SSLWrap
extends AsyncWrap {
    private SSLEngine sslEngine;
    private StreamWrap stream;
    private SecureContext context;
    private boolean requestCert;
    private boolean rejectUnauthorized;

    public SSLWrap(NodeProcess process) {
        super(process);
    }

    public void init(StreamWrap stream, SecureContext context, boolean isServer) throws Throwable {
        this.stream = stream;
        this.context = context;
        if (isServer) {
            this.start(isServer);
        }
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void start(final boolean isServer) throws Exception {
        try {
            this.sslEngine = this.context.getSSLEngine();
        }
        catch (Throwable t) {
            this.process.getNodyn().handleThrowable(t);
            throw t;
        }
        this.sslEngine.setUseClientMode(!isServer);
        SslHandler sslHandler = new SslHandler(this.sslEngine);
        Future handleshake = sslHandler.handshakeFuture();
        handleshake.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

            public void operationComplete(Future<? super Channel> future) throws Exception {
                if (future.isSuccess()) {
                    SSLWrap.this.emit("handshakedone", CallbackResult.EMPTY_SUCCESS);
                    if (isServer) {
                        SSLWrap.this.emit("newsession", CallbackResult.createSuccess("foo", "bar"));
                    }
                } else {
                    SSLWrap.this.emit("handshakedone", CallbackResult.EMPTY_SUCCESS);
                }
            }
        });
        if (this.stream.getPipeline().get("debug") != null) {
            this.stream.getPipeline().addAfter("debug", "ssl", (ChannelHandler)sslHandler);
        } else {
            this.stream.getPipeline().addFirst(new ChannelHandler[]{sslHandler});
        }
        this.emit("handshakestart", CallbackResult.EMPTY_SUCCESS);
    }

    public void receive(ByteBuf buf) {
        this.stream.getPipeline().fireChannelRead((Object)buf);
        this.stream.getPipeline().fireChannelReadComplete();
    }

    public Certificate getPeerCertificate() throws SSLPeerUnverifiedException, CertificateEncodingException {
        try {
            return this.sslEngine.getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public String getServername() {
        return this.sslEngine.getPeerHost();
    }

    public String getNegotiatedProtocol() {
        return this.sslEngine.getSession().getProtocol();
    }

    public void setVerifyMode(boolean requestCert, boolean rejectUnauthorized) {
        if (this.sslEngine != null) {
            this.sslEngine.setWantClientAuth(requestCert);
            this.sslEngine.setNeedClientAuth(rejectUnauthorized);
        }
    }
}

