/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import io.nodyn.NodeProcess;
import io.nodyn.netty.EOFEventHandler;
import io.nodyn.netty.UnrefHandler;
import io.nodyn.stream.StreamWrap;
import io.nodyn.tcp.AfterConnectEventHandler;
import io.nodyn.tcp.ConnectionEventHandler;
import io.nodyn.tcp.UnsafeTcp;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;

public class TCPWrap
extends StreamWrap {
    private String addr;
    private int port = -1;

    public TCPWrap(NodeProcess process) {
        super(process, false);
    }

    public TCPWrap(NodeProcess process, int fd) throws Exception {
        super(process, false);
        SocketChannel socketChannel = UnsafeTcp.attach(fd);
        NioSocketChannel channel = new NioSocketChannel(socketChannel);
        this.channelFuture = channel.newSucceededFuture();
        channel.pipeline().addLast("emit.afterConnect", (ChannelHandler)new AfterConnectEventHandler(this.process, this));
        channel.pipeline().addLast("emit.eof", (ChannelHandler)new EOFEventHandler(this.process, this));
        channel.pipeline().addLast("handle", (ChannelHandler)new UnrefHandler(this));
        process.getEventLoop().getEventLoopGroup().register((Channel)channel);
    }

    public TCPWrap(NodeProcess process, ChannelFuture channelFuture) {
        super(process, channelFuture);
    }

    public void bind(String addr, int port) {
        this.addr = addr;
        this.port = port;
    }

    public void listen(int backlog) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.process.getEventLoop().getEventLoopGroup());
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAutoRead(false);
                ch.pipeline().addLast("emit.connection", (ChannelHandler)new ConnectionEventHandler(TCPWrap.this.process, TCPWrap.this));
                ch.pipeline().addLast("handle", (ChannelHandler)new UnrefHandler(TCPWrap.this));
            }
        });
        this.channelFuture = bootstrap.bind(this.addr, this.port);
        this.channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
            }
        });
        this.ref();
    }

    public void connect(String addr, int port) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.process.getEventLoop().getEventLoopGroup());
        bootstrap.channel(NioSocketChannel.class);
        if (this.port >= 0) {
            if (this.addr != null) {
                bootstrap.localAddress(this.addr, this.port);
            } else {
                bootstrap.localAddress(this.port);
            }
        }
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAutoRead(false);
                ch.pipeline().addLast("emit.afterConnect", (ChannelHandler)new AfterConnectEventHandler(TCPWrap.this.process, TCPWrap.this));
                ch.pipeline().addLast("emit.eof", (ChannelHandler)new EOFEventHandler(TCPWrap.this.process, TCPWrap.this));
                ch.pipeline().addLast("handle", (ChannelHandler)new UnrefHandler(TCPWrap.this));
            }
        });
        this.channelFuture = bootstrap.connect(addr, port);
        this.channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
            }
        });
        this.ref();
    }

    @Override
    public void shutdown() throws InterruptedException {
        ((NioSocketChannel)this.channelFuture.await().channel()).shutdownOutput();
    }

    public SocketAddress getRemoteAddress() throws InterruptedException {
        return this.channelFuture.await().channel().remoteAddress();
    }

    public SocketAddress getLocalAddress() throws InterruptedException {
        return this.channelFuture.await().channel().localAddress();
    }

    public int getFd() throws NoSuchFieldException, IllegalAccessException, IOException, InterruptedException {
        return UnsafeTcp.getFd((NioSocketChannel)this.channelFuture.await().channel());
    }
}

