/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.stream;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import io.nodyn.NodeProcess;
import io.nodyn.handle.HandleWrap;
import java.io.IOException;

public class StreamWrap
extends HandleWrap {
    protected ChannelFuture channelFuture;

    public StreamWrap(NodeProcess process, boolean count) {
        super(process, count);
    }

    public StreamWrap(NodeProcess process, ChannelFuture channelFuture) {
        super(process, true);
        this.channelFuture = channelFuture;
    }

    public ChannelPipeline getPipeline() {
        return this.channelFuture.channel().pipeline();
    }

    public void readStart() {
        this.channelFuture.channel().config().setAutoRead(true);
        this.channelFuture.channel().read();
    }

    public void readStop() {
        this.channelFuture.channel().config().setAutoRead(false);
    }

    @Override
    public void close() {
        if (this.channelFuture != null && this.channelFuture.channel() != null) {
            this.channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        super.close();
    }

    public void shutdown() throws InterruptedException {
    }

    public void write(ByteBuf buf) throws IOException {
        this.channelFuture.channel().writeAndFlush((Object)buf.retain());
    }

    public void writeUtf8String(String str) throws IOException {
        ByteBuf buf = this.channelFuture.channel().alloc().buffer();
        buf.writeBytes(str.getBytes("utf8"));
        this.write(buf);
    }

    public void writeAsciiString(String str) throws IOException {
        ByteBuf buf = this.channelFuture.channel().alloc().buffer();
        buf.writeBytes(str.getBytes("us-ascii"));
        this.write(buf);
    }
}

