/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.process;

import io.netty.buffer.ByteBuf;
import io.nodyn.NodeProcess;
import io.nodyn.process.OutputConsumer;
import io.nodyn.process.UnsafeProcess;
import java.io.IOException;

public class SyncProcessWrap {
    private final NodeProcess process;
    private Process subProcess;
    private OutputConsumer stdOutConsumer;
    private OutputConsumer stdErrConsumer;

    public SyncProcessWrap(NodeProcess process) {
        this.process = process;
    }

    public int getPid() throws NoSuchFieldException, IllegalAccessException {
        return UnsafeProcess.getPid(this.subProcess);
    }

    public int spawn(String file, String ... args) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(args);
        this.subProcess = builder.start();
        this.stdOutConsumer = new OutputConsumer(this.process, this.subProcess.getInputStream());
        this.stdErrConsumer = new OutputConsumer(this.process, this.subProcess.getErrorStream());
        this.process.getEventLoop().submitBlockingTask(this.stdOutConsumer);
        this.process.getEventLoop().submitBlockingTask(this.stdErrConsumer);
        return this.subProcess.waitFor();
    }

    public ByteBuf getStdout() {
        return this.stdOutConsumer.getBuffer();
    }

    public ByteBuf getStderr() {
        return this.stdErrConsumer.getBuffer();
    }
}

