/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.process;

import io.nodyn.NodeProcess;
import io.nodyn.handle.HandleWrap;
import io.nodyn.process.ExitWaiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jnr.posix.POSIX;
import jnr.posix.SpawnFileAction;

public class ProcessWrap
extends HandleWrap {
    private int signal = -1;
    private int pid;
    private List<String> envp = new ArrayList<String>();
    private List<StdioConfig> stdio = new ArrayList<StdioConfig>();

    public ProcessWrap(NodeProcess process) {
        super(process, false);
    }

    public int getPid() throws NoSuchFieldException, IllegalAccessException {
        return this.pid;
    }

    public void addEnvPair(String pair) {
        this.envp.add(pair);
    }

    public void stdio(String type, int fd) {
        StdioConfig c = new StdioConfig();
        c.type = StdioConfig.Type.valueOf(type.toUpperCase());
        c.fd = fd;
        this.stdio.add(c);
    }

    public void spawn(String file, String ... args) throws IOException {
        POSIX posix = this.process.getPosix();
        ArrayList<String> argv = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argv.add(args[i]);
        }
        ArrayList<SpawnFileAction> fileActions = new ArrayList<SpawnFileAction>();
        int i = 0;
        for (StdioConfig each : this.stdio) {
            switch (each.type) {
                case OPEN: {
                    fileActions.add(SpawnFileAction.dup((int)each.fd, (int)i));
                    ++i;
                    break;
                }
                case CLOSE: {
                    fileActions.add(SpawnFileAction.close((int)each.fd));
                }
            }
        }
        long result = posix.posix_spawnp(args[0], fileActions, argv, this.envp);
        this.pid = (int)result;
        this.process.getEventLoop().submitBlockingTask(new ExitWaiter(this));
    }

    public void kill(int signal) throws NoSuchFieldException, IllegalAccessException {
        this.signal = signal;
        this.process.getPosix().kill(this.pid, signal);
    }

    int getSignal() {
        return this.signal;
    }

    public int waitFor() throws InterruptedException {
        int[] status = new int[1];
        int flags = 0;
        int result = this.process.getPosix().waitpid(this.pid, status, flags);
        return (status[0] & 0xFF00) >> 8;
    }

    private static final class StdioConfig {
        public Type type;
        public int fd;

        private StdioConfig() {
        }

        public static enum Type {
            OPEN,
            CLOSE;

        }
    }
}

