/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.netty.pipe.ipc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.embedded.EmbeddedChannel;
import io.nodyn.NodeProcess;
import io.nodyn.netty.pipe.ipc.IPCDataEventHandler;
import io.nodyn.netty.pipe.ipc.IPCRecord;
import io.nodyn.pipe.PipeWrap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jnr.constants.platform.SocketLevel;
import jnr.posix.CmsgHdr;
import jnr.posix.MsgHdr;
import jnr.posix.POSIX;

public class DuplexIPCChannel
extends EmbeddedChannel {
    private final Object outboundNotifier = new Object();
    private final POSIX posix;
    private final int fd;
    private final NodeProcess process;
    private Thread inPump;
    private Thread outPump;
    private boolean closed;

    public DuplexIPCChannel(PipeWrap pipe, POSIX posix, int fd) {
        super(new ChannelHandler[]{new IPCDataEventHandler(pipe.getProcess(), pipe)});
        this.process = pipe.getProcess();
        this.posix = posix;
        this.fd = fd;
        this.startPumps();
    }

    protected void startPumps() {
        this.inPump = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DuplexIPCChannel.this.doReadLoop();
                }
                catch (Throwable t) {
                    DuplexIPCChannel.this.process.getNodyn().handleThrowable(t);
                }
            }
        });
        this.inPump.setDaemon(true);
        this.inPump.start();
        this.outPump = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DuplexIPCChannel.this.doWriteLoop();
                }
                catch (Throwable t) {
                    DuplexIPCChannel.this.process.getNodyn().handleThrowable(t);
                }
            }
        });
        this.outPump.setDaemon(true);
        this.outPump.start();
    }

    public ChannelFuture close() {
        MsgHdr message = this.posix.allocateMsgHdr();
        ByteBuffer nioBuf = ByteBuffer.allocateDirect(1);
        nioBuf.put((byte)0);
        nioBuf.flip();
        message.setIov(new ByteBuffer[]{nioBuf});
        int result = this.posix.sendmsg(this.fd, message, 0);
        result = this.posix.fsync(this.fd);
        this.closed = true;
        this.posix.close(this.fd);
        this.inPump.interrupt();
        this.outPump.interrupt();
        return super.close();
    }

    protected void doReadLoop() {
        block5: {
            while (true) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
                MsgHdr message = this.posix.allocateMsgHdr();
                message.allocateControl(4);
                message.setIov(new ByteBuffer[]{buffer});
                CmsgHdr control = message.getControls()[0];
                int numRead = this.posix.recvmsg(this.fd, message, 0);
                if (numRead < 0) {
                    if (this.closed) break block5;
                    this.writeInbound(new Object[]{new IPCRecord(null, -1)});
                    break block5;
                }
                if (numRead <= 0) break;
                if (numRead == 1) {
                    int position = buffer.position();
                    if (buffer.get() == 0) {
                        this.writeInbound(new Object[]{new IPCRecord(null, -1)});
                        break block5;
                    }
                    buffer.position(position);
                }
                int fd = -1;
                buffer.limit(numRead);
                ByteBuf nettyBuf = this.alloc().buffer(numRead);
                nettyBuf.writeBytes(buffer);
                if (control.getType() == 1 && control.getLevel() == SocketLevel.SOL_SOCKET.intValue()) {
                    fd = control.getData().order(ByteOrder.nativeOrder()).getInt();
                }
                IPCRecord record = new IPCRecord(nettyBuf, fd);
                this.writeInbound(new Object[]{record});
            }
            this.writeInbound(new Object[]{new IPCRecord(null, -1)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteLoop() {
        try {
            while (true) {
                Object outbound = null;
                Object object = this.outboundNotifier;
                synchronized (object) {
                    while (this.outboundMessages().isEmpty()) {
                        this.outboundNotifier.wait();
                    }
                    outbound = this.outboundMessages().poll();
                }
                this.doWriteOutbound(outbound);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected void doWriteOutbound(Object outbound) {
        int fd = -1;
        ByteBuf buf = null;
        if (outbound instanceof IPCRecord) {
            buf = ((IPCRecord)outbound).getBuffer();
            fd = ((IPCRecord)outbound).getFd();
        } else if (outbound instanceof ByteBuf) {
            buf = (ByteBuf)outbound;
        } else {
            return;
        }
        ByteBuffer nioBuf = ByteBuffer.allocateDirect(buf.readableBytes());
        buf.readBytes(nioBuf);
        nioBuf.flip();
        MsgHdr message = this.posix.allocateMsgHdr();
        message.setIov(new ByteBuffer[]{nioBuf});
        if (fd >= 0) {
            CmsgHdr control = message.allocateControl(4);
            ByteBuffer fdBuf = ByteBuffer.allocateDirect(4);
            fdBuf.order(ByteOrder.nativeOrder());
            fdBuf.putInt(fd);
            fdBuf.flip();
            control.setData(fdBuf);
            control.setType(1);
            control.setLevel(SocketLevel.SOL_SOCKET.intValue());
        }
        int result = this.posix.sendmsg(this.fd, message, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        super.doWrite(in);
        Object object = this.outboundNotifier;
        synchronized (object) {
            this.outboundNotifier.notifyAll();
        }
    }
}

