/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.natives;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class NativesWrap {
    public static String getSource(String name) throws IOException {
        try {
            StringBuilder source = new StringBuilder();
            InputStream in = NativesWrap.class.getClassLoader().getResourceAsStream(name + ".js");
            NativesWrap.appendSource(in, source);
            NativesWrap.applyAnnex(name, source);
            return source.toString();
        }
        catch (Throwable t) {
            System.err.println("error loading: " + name);
            throw t;
        }
    }

    private static void applyAnnex(String name, StringBuilder source) throws IOException {
        InputStream in = NativesWrap.class.getClassLoader().getResourceAsStream("nodyn/annex/" + name + ".js");
        if (in == null) {
            return;
        }
        NativesWrap.appendSource(in, source);
    }

    private static void appendSource(InputStream in, StringBuilder source) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        char[] buf = new char[4096];
        int numRead = 0;
        while ((numRead = reader.read(buf)) >= 0) {
            source.append(buf, 0, numRead);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

