/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.loop;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.nodyn.NodeProcess;
import io.nodyn.loop.RefCounted;
import io.nodyn.loop.RefHandle;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EventLoop
implements RefCounted {
    private final ScheduledExecutorService userTaskExecutor;
    private final ExecutorService blockingTaskExecutor;
    private CountDownLatch latch = new CountDownLatch(1);
    private EventLoopGroup eventLoopGroup;
    private final boolean controlLifecycle;
    private final AtomicInteger taskCounter = new AtomicInteger();
    private Set<RefHandle> handles = new HashSet<RefHandle>();
    protected int counter;
    private NodeProcess process;

    public EventLoop(EventLoopGroup eventLoopGroup) {
        this(eventLoopGroup, true);
    }

    public EventLoop(EventLoopGroup eventLoopGroup, boolean controlLifecycle) {
        this.eventLoopGroup = eventLoopGroup;
        this.controlLifecycle = controlLifecycle;
        final CountDownLatch latch = new CountDownLatch(1);
        this.eventLoopGroup.submit(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.process.getNodyn().handleThrowable(e);
            this.eventLoopGroup = null;
        }
        this.userTaskExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "user-tasks");
                return t;
            }
        });
        this.blockingTaskExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "blocking-task");
                return t;
            }
        });
    }

    public void setProcess(NodeProcess process) {
        this.process = process;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public java.util.concurrent.Future<?> submitUserTask(final Runnable task, String name) {
        final RefHandle handle = this.newHandle("user-task#" + name);
        this.taskCounter.incrementAndGet();
        return this.userTaskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                finally {
                    try {
                        EventLoop.this.taskComplete();
                    }
                    catch (Throwable t) {
                        EventLoop.this.process.getNodyn().handleThrowable(t);
                    }
                }
                handle.unref();
            }
        });
    }

    private void taskComplete() {
        int val = this.taskCounter.decrementAndGet();
        if (val == 0) {
            this.process.doNextTick();
        }
    }

    public ScheduledFuture<?> scheduleUserTask(Runnable task, int time, TimeUnit units) {
        return this.userTaskExecutor.schedule(task, (long)time, units);
    }

    public java.util.concurrent.Future<?> submitBlockingTask(final Runnable task) {
        return this.blockingTaskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    EventLoop.this.process.getNodyn().handleThrowable(t);
                }
            }
        });
    }

    public int refCount() {
        return this.counter;
    }

    @Override
    public RefHandle newHandle(String name) {
        return this.newHandle(true, name);
    }

    public RefHandle newHandle(boolean count, String name) {
        return new RefHandle(this, count, name);
    }

    public void dump() {
        System.err.println(" ---- ");
        System.err.println(this.handles);
        System.err.println(" ---- ");
    }

    @Override
    public synchronized void incrCount(RefHandle handle) {
        ++this.counter;
        this.handles.add(handle);
    }

    @Override
    public synchronized void decrCount(RefHandle handle) {
        --this.counter;
        this.handles.remove(handle);
        if (this.counter == 0) {
            this.doShutdown();
        }
    }

    public void shutdown() {
        this.doShutdown();
    }

    protected void doShutdown() {
        if (this.eventLoopGroup != null) {
            if (this.controlLifecycle) {
                Future future = this.eventLoopGroup.shutdownGracefully(0L, 2L, TimeUnit.SECONDS);
                future.addListener((GenericFutureListener)new FutureListener<Object>(){

                    public void operationComplete(Future<Object> future) throws Exception {
                        EventLoop.this.userTaskExecutor.shutdown();
                        EventLoop.this.blockingTaskExecutor.shutdown();
                        EventLoop.this.latch.countDown();
                    }
                });
                this.eventLoopGroup = null;
            } else {
                this.userTaskExecutor.shutdown();
                this.blockingTaskExecutor.shutdown();
                this.latch.countDown();
            }
        }
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public NodeProcess getProcess() {
        return this.process;
    }
}

