/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.dns;

import io.nodyn.CallbackResult;
import io.nodyn.NodeProcess;
import io.nodyn.dns.AbstractQueryWrap;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GetAddrInfo4Wrap
extends AbstractQueryWrap {
    public GetAddrInfo4Wrap(NodeProcess process, String name) {
        super(process, name);
    }

    @Override
    public void start() {
        if (this.name.equals("localhost")) {
            this.process.getEventLoop().getEventLoopGroup().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean found = false;
                        InetAddress[] addrs = InetAddress.getAllByName(GetAddrInfo4Wrap.this.name);
                        for (int i = 0; i < addrs.length; ++i) {
                            if (!(addrs[i] instanceof Inet4Address)) continue;
                            GetAddrInfo4Wrap.this.emit("complete", CallbackResult.createSuccess((Object)addrs[i]));
                            found = true;
                            break;
                        }
                        if (!found) {
                            GetAddrInfo4Wrap.this.emit("complete", CallbackResult.createError(new UnknownHostException()));
                        }
                    }
                    catch (UnknownHostException e) {
                        GetAddrInfo4Wrap.this.emit("complete", CallbackResult.createError(e));
                    }
                }
            });
        } else {
            this.dnsClient().lookup4(this.name, this.handler());
        }
    }
}

