/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class Hmac {
    private final HMac hmac;

    public Hmac(Digest digest, ByteBuf key) throws InvalidKeyException {
        this.hmac = new HMac(digest);
        this.computeKey(key);
    }

    private void computeKey(ByteBuf key) throws InvalidKeyException {
        byte[] keyBytes = new byte[key.readableBytes()];
        key.readBytes(keyBytes);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, this.hmac.getUnderlyingDigest().getAlgorithmName());
        KeyParameter param = new KeyParameter(secretKey.getEncoded());
        this.hmac.init((CipherParameters)param);
    }

    public void update(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), bytes);
        this.hmac.update(bytes, 0, bytes.length);
    }

    public ByteBuf digest() throws NoSuchAlgorithmException {
        byte[] digestBytes = new byte[this.hmac.getMacSize()];
        this.hmac.doFinal(digestBytes, 0);
        return Unpooled.wrappedBuffer((byte[])digestBytes);
    }
}

