/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.Digest;

public class Hash {
    private final Digest digest;

    public Hash(Digest digest) {
        this.digest = digest;
    }

    public void update(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), bytes);
        this.digest.update(bytes, 0, bytes.length);
    }

    public ByteBuf digest() throws NoSuchAlgorithmException {
        byte[] digestBytes = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(digestBytes, 0);
        return Unpooled.wrappedBuffer((byte[])digestBytes);
    }
}

