/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.cli;

import io.nodyn.Nodyn;
import io.nodyn.runtime.NodynConfig;
import io.nodyn.runtime.RuntimeFactory;
import java.io.File;
import java.io.IOException;

public class Main {
    private NodynConfig config;
    private Nodyn nodyn;

    public Main(String[] args) {
        this.config = new NodynConfig(args);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        int exitCode = new Main(args).run();
        System.exit(exitCode);
    }

    public int run() {
        if (this.config.isHelp()) {
            return this.runHelp();
        }
        if (this.config.isVersion()) {
            return this.runVersion();
        }
        return this.runNormal();
    }

    protected int runHelp() {
        System.err.println("Usage: node [options] [ -e script | script.js ] [arguments] \n       node debug script.js [arguments] \n\nOptions:\n  -v, --version        print node's version\n  -e, --eval script    evaluate script\n  -p, --print          evaluate script and print result\n  -i, --interactive    always enter the REPL even if stdin\n                       does not appear to be a terminal\n  --no-deprecation     silence deprecation warnings\n  --throw-deprecation  throw an exception anytime a deprecated function is used\n  --trace-deprecation  show stack traces on deprecations\n  --v8-options         print v8 command line options\n  --max-stack-size=val set max v8 stack size (bytes)\n\nEnvironment variables:\nNODE_PATH              '" + File.pathSeparator + "'-separated list of directories\n" + "                       prefixed to the module search path.\n" + "NODE_MODULE_CONTEXTS   Set to 1 to load modules in their own\n" + "                       global contexts.\n" + "NODE_DISABLE_COLORS    Set to 1 to disable colors in the REPL\n" + "\n" + "Documentation can be found at http://nodejs.org/\n");
        return 0;
    }

    protected int runVersion() {
        System.err.println("v" + Nodyn.NODE_VERSION + " (v" + Nodyn.VERSION + ")");
        return 0;
    }

    protected int runNormal() {
        RuntimeFactory factory = RuntimeFactory.init(this.config.getClassLoader(), RuntimeFactory.RuntimeType.DYNJS);
        this.nodyn = factory.newRuntime(this.config);
        try {
            return this.nodyn.run();
        }
        catch (Throwable t) {
            this.nodyn.handleThrowable(t);
            return -255;
        }
    }
}

