/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn;

import io.netty.channel.EventLoopGroup;
import io.nodyn.Callback;
import io.nodyn.CallbackResult;
import io.nodyn.ExitHandler;
import io.nodyn.NodeProcess;
import io.nodyn.crypto.CryptoInitializer;
import io.nodyn.loop.EventLoop;
import io.nodyn.runtime.NodynConfig;
import io.nodyn.runtime.Program;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.VertxInternal;

public abstract class Nodyn {
    public static final String VERSION;
    public static final String NODE_VERSION;
    protected static final String NODE_JS = "node.js";
    protected static final String PROCESS = "nodyn/process.js";
    protected static final String ES6_POLYFILL = "nodyn/polyfill.js";
    private final EventLoop eventLoop;
    private final CompletionHandler completionHandler;
    private final Vertx vertx;
    private final NodynConfig config;
    private ExitHandler exitHandler;

    private static String loadVersion(String component) throws IOException {
        InputStream in = Nodyn.class.getClassLoader().getResourceAsStream(component + "-version.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        reader.close();
        return line.trim();
    }

    public abstract Object loadBinding(String var1);

    public abstract void handleThrowable(Throwable var1);

    protected abstract NodeProcess initialize();

    protected abstract Object runScript(String var1) throws IOException;

    public abstract Object getGlobalContext();

    public abstract Program compile(String var1, String var2, boolean var3) throws Throwable;

    public abstract void makeContext(Object var1);

    public abstract boolean isContext(Object var1);

    protected Nodyn(NodynConfig config, Vertx vertx, boolean controlLifeCycle) {
        EventLoopGroup elg = ((VertxInternal)vertx).getEventLoopGroup();
        this.eventLoop = new EventLoop(elg, controlLifeCycle);
        this.vertx = vertx;
        this.config = config;
        this.completionHandler = new CompletionHandler();
    }

    public int run() throws Throwable {
        this.start(null);
        return this.await();
    }

    public void runAsync(Callback callback) {
        this.start(callback);
    }

    public NodynConfig getConfiguration() {
        return this.config;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setExitHandler(ExitHandler handle) {
        this.exitHandler = handle;
    }

    public void reallyExit(int exitCode) {
        this.eventLoop.shutdown();
        if (this.exitHandler != null) {
            this.exitHandler.reallyExit(exitCode);
        } else {
            System.exit(exitCode);
        }
    }

    private int await() throws Throwable {
        this.eventLoop.await();
        if (this.completionHandler.error != null) {
            throw this.completionHandler.error;
        }
        if (this.completionHandler.process == null) {
            return -255;
        }
        return this.completionHandler.process.getExitCode();
    }

    private void start(final Callback callback) {
        this.eventLoop.submitUserTask(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        ((Nodyn)Nodyn.this).completionHandler.process = Nodyn.this.initialize();
                        if (callback != null) {
                            callback.call(CallbackResult.createSuccess());
                        }
                    }
                    catch (Throwable t) {
                        ((Nodyn)Nodyn.this).completionHandler.error = t;
                        if (callback == null) break block3;
                        callback.call(CallbackResult.createError(t));
                    }
                }
            }
        }, "init");
    }

    static {
        String v;
        CryptoInitializer.initialize();
        try {
            v = Nodyn.loadVersion("nodyn");
        }
        catch (IOException e) {
            v = "Unknown";
        }
        VERSION = v;
        try {
            v = Nodyn.loadVersion("node");
        }
        catch (IOException e) {
            v = "Unknown";
        }
        NODE_VERSION = v;
    }

    private static class CompletionHandler {
        public NodeProcess process;
        public Throwable error;

        private CompletionHandler() {
        }
    }
}

