/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn;

import io.nodyn.CallbackResult;
import io.nodyn.EventSource;
import io.nodyn.Nodyn;
import io.nodyn.extension.ExtensionLoader;
import io.nodyn.fs.UnsafeFs;
import io.nodyn.loop.EventLoop;
import io.nodyn.loop.ImmediateCheckHandle;
import io.nodyn.posix.NodePosixHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.POSIXHandler;
import org.vertx.java.core.Vertx;

public class NodeProcess
extends EventSource {
    private final Map<String, Object> bindings = new HashMap<String, Object>();
    private final Nodyn nodyn;
    private final String osName;
    private final String osArch;
    private final POSIX posix;
    private ImmediateCheckHandle immediateCheckHandle;
    private boolean needImmediateCallback;
    private int exitCode = 0;
    private Runnable tickCallback;
    private ExtensionLoader extensionLoader;

    public NodeProcess(Nodyn nodyn) {
        this(nodyn, System.getProperties());
    }

    public NodeProcess(Nodyn nodyn, Properties props) {
        this.nodyn = nodyn;
        this.osName = props.getProperty("os.name").toLowerCase();
        this.osArch = props.getProperty("os.arch").toLowerCase();
        this.immediateCheckHandle = new ImmediateCheckHandle(nodyn.getEventLoop(), new Runnable(){

            @Override
            public void run() {
                NodeProcess.this.emit("checkImmediate", CallbackResult.EMPTY_SUCCESS);
            }
        });
        this.posix = POSIXFactory.getPOSIX((POSIXHandler)new NodePosixHandler(), (boolean)true);
        this.extensionLoader = new ExtensionLoader(nodyn.getConfiguration().getClassLoader());
    }

    public Object jaropen(String filename) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, IOException {
        return this.extensionLoader.load(filename);
    }

    public long getPid() {
        return this.getPosix().getpid();
    }

    public boolean isatty(int fd) throws NoSuchFieldException, IllegalAccessException {
        return this.posix.isatty(UnsafeFs.createFileDescriptor(fd));
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void reallyExit() {
        this.nodyn.reallyExit(this.exitCode);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setupNextTick(Runnable tickCallback) {
        this.tickCallback = tickCallback;
        this.doNextTick();
    }

    public void doNextTick() {
        this.tickCallback.run();
    }

    public boolean getNeedImmediateCallback() {
        return this.needImmediateCallback;
    }

    public void setNeedImmediateCallback(boolean v) {
        if (this.immediateCheckHandle.isActive() == v) {
            return;
        }
        this.needImmediateCallback = v;
        if (v) {
            this.immediateCheckHandle.start();
        } else {
            this.immediateCheckHandle.stop();
        }
    }

    public Nodyn getNodyn() {
        return this.nodyn;
    }

    public EventLoop getEventLoop() {
        return this.nodyn.getEventLoop();
    }

    public Vertx getVertx() {
        return this.nodyn.getVertx();
    }

    public Object binding(String name) {
        Object binding = this.bindings.get(name);
        if (binding == null) {
            binding = this.loadBinding(name);
            this.bindings.put(name, binding);
        }
        return binding;
    }

    protected Object loadBinding(String name) {
        return this.nodyn.loadBinding(name);
    }

    public String getArgv0() {
        String bin = System.getProperty("nodyn.binary");
        if (bin == null) {
            bin = "nodyn";
        }
        return bin;
    }

    public String getExecPath() {
        String bin = System.getProperty("nodyn.binary");
        if (bin == null) {
            bin = "nodyn";
        }
        File nodynBinary = new File(bin);
        nodynBinary = nodynBinary.getAbsoluteFile();
        String path = nodynBinary.getAbsolutePath();
        return path;
    }

    public String platform() {
        if (this.isLinux()) {
            return "linux";
        }
        if (this.isMac()) {
            return "darwin";
        }
        if (this.isFreeBSD()) {
            return "freebsd";
        }
        if (this.isSunos()) {
            return "sunos";
        }
        if (this.isWindows()) {
            return "win32";
        }
        return null;
    }

    public boolean isLinux() {
        return this.osName.indexOf("linux") >= 0;
    }

    public boolean isMac() {
        return this.osName.indexOf("darwin") >= 0 || this.osName.indexOf("mac") >= 0;
    }

    public boolean isFreeBSD() {
        return this.osName.indexOf("freebsd") >= 0;
    }

    public boolean isSunos() {
        return this.osName.indexOf("sunos") >= 0;
    }

    public boolean isWindows() {
        return this.osName.indexOf("win") >= 0;
    }

    public String arch() {
        if (this.isX64()) {
            return "x64";
        }
        if (this.isIa32()) {
            return "ia32";
        }
        if (this.isArm()) {
            return "arm";
        }
        return null;
    }

    public boolean isIa32() {
        return this.osArch.indexOf("x86") >= 0 || this.osArch.indexOf("i386") >= 0;
    }

    public boolean isX64() {
        return this.osArch.indexOf("amd64") >= 0 || this.osArch.indexOf("x86_64") >= 0;
    }

    public boolean isArm() {
        return this.osArch.indexOf("arm") >= 0;
    }

    public POSIX getPosix() {
        return this.posix;
    }
}

