/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.impl.I2CDeviceImpl;
import com.pi4j.jni.I2C;
import java.io.IOException;

public class I2CBusImpl
implements I2CBus {
    private static I2CBus bus0 = null;
    private static I2CBus bus1 = null;
    protected int fd;
    protected String filename;

    public static I2CBus getBus(int busNumber) throws IOException {
        I2CBus bus = null;
        if (busNumber == 0) {
            bus = bus0;
            if (bus == null) {
                bus0 = bus = new I2CBusImpl("/dev/i2c-0");
            }
        } else if (busNumber == 1) {
            bus = bus1;
            if (bus == null) {
                bus1 = bus = new I2CBusImpl("/dev/i2c-1");
            }
        } else {
            throw new IOException("Unknown bus number " + busNumber);
        }
        return bus;
    }

    public I2CBusImpl(String filename) throws IOException {
        this.filename = filename;
        this.fd = I2C.i2cOpen(filename);
        if (this.fd < 0) {
            throw new IOException("Cannot open file handle for " + filename + " got " + this.fd + " back.");
        }
    }

    @Override
    public I2CDevice getDevice(int address) throws IOException {
        return new I2CDeviceImpl(this, address);
    }

    @Override
    public void close() throws IOException {
        I2C.i2cClose(this.fd);
    }
}

