/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsapi;

import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.util.Microphone;
import edu.cmu.sphinx.jsapi.SphinxRecognizer;
import edu.cmu.sphinx.recognizer.Recognizer;

final class RecognitionThread
extends Thread {
    private SphinxRecognizer recognizer;

    public RecognitionThread(SphinxRecognizer rec) {
        this.recognizer = rec;
        this.setDaemon(true);
        this.setName("SphinxRecognitionThread");
    }

    @Override
    public void run() {
        boolean started;
        Recognizer rec = this.recognizer.getRecognizer();
        Microphone microphone = this.getMicrophone();
        if (microphone != null) {
            microphone.clear();
            started = microphone.startRecording();
        } else {
            started = true;
        }
        if (started) {
            this.recognize(rec, microphone);
        }
        if (microphone != null) {
            while (microphone.isRecording()) {
                microphone.stopRecording();
            }
        }
    }

    private void recognize(Recognizer rec, Microphone mic) {
        while (this.hasMoreData(mic) && !this.isInterrupted()) {
            try {
                rec.recognize();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean hasMoreData(Microphone mic) {
        if (mic == null) {
            return true;
        }
        return mic.hasMoreData();
    }

    public void stopRecognition() {
        Microphone microphone = this.getMicrophone();
        if (microphone != null) {
            microphone.stopRecording();
        }
        this.interrupt();
    }

    private Microphone getMicrophone() {
        DataProcessor dataProcessor = this.recognizer.getDataProcessor();
        if (dataProcessor instanceof Microphone) {
            return (Microphone)dataProcessor;
        }
        return null;
    }
}

