/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.BaseEngineProperties;
import java.beans.PropertyVetoException;
import javax.speech.SpeechError;
import javax.speech.synthesis.SynthesizerProperties;
import javax.speech.synthesis.Voice;

public class BaseSynthesizerProperties
extends BaseEngineProperties
implements SynthesizerProperties {
    protected Voice defaultVoice;
    protected float defaultPitch;
    protected float defaultPitchRange;
    protected float defaultSpeakingRate;
    protected float defaultVolume;
    protected Voice currentVoice;
    protected float currentPitch;
    protected float currentPitchRange;
    protected float currentSpeakingRate;
    protected float currentVolume;

    public BaseSynthesizerProperties() {
        this.defaultVoice = null;
        this.defaultPitch = 0.0f;
        this.defaultPitchRange = 0.0f;
        this.defaultSpeakingRate = 0.0f;
        this.defaultVolume = 0.0f;
    }

    public BaseSynthesizerProperties(Voice defaultVoice, float defaultPitch, float defaultPitchRange, float defaultSpeakingRate, float defaultVolume) {
        this.defaultVoice = defaultVoice != null ? (Voice)defaultVoice.clone() : null;
        this.defaultPitch = defaultPitch;
        this.defaultPitchRange = defaultPitchRange;
        this.defaultSpeakingRate = defaultSpeakingRate;
        this.defaultVolume = defaultVolume;
        this.currentVoice = defaultVoice != null ? (Voice)defaultVoice.clone() : null;
        this.currentPitch = defaultPitch;
        this.currentPitchRange = defaultPitchRange;
        this.currentSpeakingRate = defaultSpeakingRate;
        this.currentVolume = defaultVolume;
    }

    @Override
    public void reset() {
        try {
            this.setVoice(this.defaultVoice);
            this.setVolume(this.defaultVolume);
            this.setPitch(this.defaultPitch);
            this.setPitchRange(this.defaultPitchRange);
            this.setSpeakingRate(this.defaultSpeakingRate);
        }
        catch (PropertyVetoException e) {
            throw new SpeechError("Inconsistent default properties");
        }
    }

    @Override
    public Voice getVoice() {
        return (Voice)this.currentVoice.clone();
    }

    @Override
    public void setVoice(Voice voice) throws PropertyVetoException {
        Voice oldVoice = this.currentVoice;
        this.currentVoice = (Voice)voice.clone();
        this.postPropertyChangeEvent("Voice", oldVoice, voice);
    }

    @Override
    public float getPitch() {
        return this.currentPitch;
    }

    @Override
    public void setPitch(float hertz) throws PropertyVetoException {
        float oldPitch = this.currentPitch;
        this.currentPitch = hertz;
        this.postPropertyChangeEvent("Pitch", oldPitch, hertz);
    }

    @Override
    public float getPitchRange() {
        return this.currentPitchRange;
    }

    @Override
    public void setPitchRange(float hertz) throws PropertyVetoException {
        float oldRange = this.currentPitchRange;
        this.currentPitchRange = hertz;
        this.postPropertyChangeEvent("PitchRange", oldRange, hertz);
    }

    @Override
    public float getSpeakingRate() {
        return this.currentSpeakingRate;
    }

    @Override
    public void setSpeakingRate(float wpm) throws PropertyVetoException {
        float oldRate = this.currentSpeakingRate;
        this.currentSpeakingRate = wpm;
        this.postPropertyChangeEvent("SpeakingRate", oldRate, wpm);
    }

    @Override
    public float getVolume() {
        return this.currentVolume;
    }

    @Override
    public void setVolume(float volume) throws PropertyVetoException {
        if (volume > 1.0f) {
            volume = 1.0f;
        } else if (volume < 0.0f) {
            volume = 0.0f;
        }
        float oldVolume = this.currentVolume;
        this.currentVolume = volume;
        this.postPropertyChangeEvent("Volume", oldVolume, volume);
    }
}

