/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.BaseEngine;
import com.sun.speech.engine.BaseEngineProperties;
import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.synthesis.BaseSynthesizerProperties;
import com.sun.speech.engine.synthesis.BaseSynthesizerQueueItem;
import com.sun.speech.engine.synthesis.BaseVoice;
import com.sun.speech.engine.synthesis.VoiceList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.speech.EngineListener;
import javax.speech.EngineStateError;
import javax.speech.SpeechEvent;
import javax.speech.synthesis.JSMLException;
import javax.speech.synthesis.Speakable;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerEvent;
import javax.speech.synthesis.SynthesizerListener;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.SynthesizerProperties;

public abstract class BaseSynthesizer
extends BaseEngine
implements Synthesizer,
SpeechEventDispatcher {
    protected Collection<SpeakableListener> speakableListeners = new ArrayList<SpeakableListener>();
    protected VoiceList voiceList;

    public BaseSynthesizer(SynthesizerModeDesc mode) {
        super(mode);
        this.voiceList = new VoiceList(mode);
    }

    @Override
    public void speak(Speakable jsmlText, SpeakableListener listener) throws JSMLException, EngineStateError {
        this.checkEngineState(9L);
        BaseSynthesizerQueueItem item = this.createQueueItem();
        item.setData(this, jsmlText, listener);
        this.appendQueue(item);
    }

    @Override
    public void speak(URL jsmlURL, SpeakableListener listener) throws JSMLException, MalformedURLException, IOException, EngineStateError {
        this.checkEngineState(9L);
        BaseSynthesizerQueueItem item = this.createQueueItem();
        item.setData(this, jsmlURL, listener);
        this.appendQueue(item);
    }

    @Override
    public void speak(String jsmlText, SpeakableListener listener) throws JSMLException, EngineStateError {
        this.checkEngineState(9L);
        BaseSynthesizerQueueItem item = this.createQueueItem();
        item.setData(this, jsmlText, false, listener);
        this.appendQueue(item);
    }

    @Override
    public void speakPlainText(String text, SpeakableListener listener) throws EngineStateError {
        this.checkEngineState(9L);
        try {
            BaseSynthesizerQueueItem item = this.createQueueItem();
            item.setData(this, text, true, listener);
            this.appendQueue(item);
        }
        catch (JSMLException e) {
            throw new RuntimeException("JSMLException should never occur");
        }
    }

    @Override
    protected String stateToString(long state) {
        StringBuilder buf = new StringBuilder();
        if ((state & 0x10000L) != 0L) {
            buf.append(" QUEUE_EMPTY ");
        }
        if ((state & 0x20000L) != 0L) {
            buf.append(" QUEUE_NOT_EMPTY ");
        }
        return super.stateToString(state) + buf.toString();
    }

    protected abstract void appendQueue(BaseSynthesizerQueueItem var1);

    @Override
    public String phoneme(String text) throws EngineStateError {
        this.checkEngineState(9L);
        return null;
    }

    @Override
    public abstract Enumeration<?> enumerateQueue() throws EngineStateError;

    @Override
    public abstract void cancel() throws EngineStateError;

    @Override
    public abstract void cancel(Object var1) throws IllegalArgumentException, EngineStateError;

    @Override
    public abstract void cancelAll() throws EngineStateError;

    @Override
    public SynthesizerProperties getSynthesizerProperties() {
        this.checkEngineState(9L);
        return (SynthesizerProperties)this.getEngineProperties();
    }

    @Override
    public void addSpeakableListener(SpeakableListener listener) {
        if (!this.speakableListeners.contains(listener)) {
            this.speakableListeners.add(listener);
        }
    }

    @Override
    public void removeSpeakableListener(SpeakableListener listener) {
        this.speakableListeners.remove(listener);
    }

    @Override
    protected BaseEngineProperties createEngineProperties() {
        SynthesizerModeDesc desc = (SynthesizerModeDesc)this.engineModeDesc;
        BaseVoice defaultVoice = (BaseVoice)desc.getVoices()[0];
        float defaultPitch = defaultVoice.defaultPitch;
        float defaultPitchRange = defaultVoice.defaultPitchRange;
        float defaultSpeakingRate = defaultVoice.defaultSpeakingRate;
        float defaultVolume = defaultVoice.defaultVolume;
        return new BaseSynthesizerProperties(defaultVoice, defaultPitch, defaultPitchRange, defaultSpeakingRate, defaultVolume);
    }

    protected BaseSynthesizerQueueItem createQueueItem() {
        return new BaseSynthesizerQueueItem();
    }

    protected VoiceList getVoiceList() {
        return this.voiceList;
    }

    public void postQueueUpdated(boolean topOfQueueChanged, long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new SynthesizerEvent(this, 701, topOfQueueChanged, oldState, newState));
    }

    public void fireQueueUpdated(SynthesizerEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        for (EngineListener el : this.engineListeners) {
            if (!(el instanceof SynthesizerListener)) continue;
            SynthesizerListener sl = (SynthesizerListener)el;
            sl.queueUpdated(event);
        }
    }

    public void postQueueEmptied(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new SynthesizerEvent(this, 700, false, oldState, newState));
    }

    public void fireQueueEmptied(SynthesizerEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        for (EngineListener el : this.engineListeners) {
            if (!(el instanceof SynthesizerListener)) continue;
            SynthesizerListener sl = (SynthesizerListener)el;
            sl.queueEmptied(event);
        }
    }

    @Override
    public void dispatchSpeechEvent(SpeechEvent event) {
        switch (event.getId()) {
            case 700: {
                this.fireQueueEmptied((SynthesizerEvent)event);
                break;
            }
            case 701: {
                this.fireQueueUpdated((SynthesizerEvent)event);
                break;
            }
            default: {
                super.dispatchSpeechEvent(event);
            }
        }
    }
}

