/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.recognition;

import com.sun.speech.engine.recognition.BaseRecognizer;
import com.sun.speech.engine.recognition.BaseRuleGrammar;
import com.sun.speech.engine.recognition.RuleState;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.speech.recognition.GrammarException;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleAlternatives;
import javax.speech.recognition.RuleCount;
import javax.speech.recognition.RuleGrammar;
import javax.speech.recognition.RuleName;
import javax.speech.recognition.RuleSequence;
import javax.speech.recognition.RuleTag;

public class RecognizerUtilities {
    public static PrintStream errOutput = System.err;

    public static void copyGrammar(RuleGrammar gramFrom, RuleGrammar gramTo) throws GrammarException {
        for (RuleName ruleName : gramFrom.listImports()) {
            gramTo.addImport(ruleName);
        }
        for (String string : gramFrom.listRuleNames()) {
            boolean isPublic = false;
            try {
                isPublic = gramFrom.isRulePublic(string);
            }
            catch (IllegalArgumentException nse) {
                throw new GrammarException(nse.toString(), null);
            }
            Rule rule = gramFrom.getRule(string);
            try {
                gramTo.setRule(string, rule, isPublic);
                if (!gramFrom.isEnabled(string)) continue;
                gramTo.setEnabled(string, true);
            }
            catch (IllegalArgumentException E) {
                throw new GrammarException(E.toString(), null);
            }
        }
    }

    public static void copyGrammars(Recognizer recFrom, Recognizer recTo) throws GrammarException {
        RuleGrammar[] gramFrom;
        for (RuleGrammar grammar : gramFrom = recFrom.listRuleGrammars()) {
            String name = grammar.getName();
            RuleGrammar gramTo = recTo.getRuleGrammar(name);
            if (gramTo == null) {
                try {
                    gramTo = recTo.newRuleGrammar(name);
                }
                catch (IllegalArgumentException gse) {
                    throw new GrammarException("copyGrammars: " + gse, null);
                }
            }
            RecognizerUtilities.copyGrammar(grammar, gramTo);
        }
    }

    public static void main(String[] args) {
        BaseRecognizer R = null;
        if (args.length < 1) {
            System.out.println("usage: java GXFormer grammar-file");
            return;
        }
        boolean elimVOID = true;
        boolean elimNULL = true;
        if (args.length > 1) {
            elimNULL = Boolean.parseBoolean(args[1]);
        }
        if (args.length > 2) {
            elimVOID = Boolean.parseBoolean(args[2]);
        }
        try {
            R = new BaseRecognizer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (R == null) {
            System.out.println("failed to create a recognizer");
            return;
        }
        try {
            R.allocate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RuleGrammar G = null;
        URL u = null;
        File f = new File(".");
        try {
            u = new URL("file:" + f.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            System.out.println("Could not get URL for current directory " + e);
            return;
        }
        try {
            G = R.loadJSGF(u, args[0]);
        }
        catch (Exception e1) {
            System.out.println("GRAMMAR ERROR: In grammar " + args[0] + ", or its imports, at URL base " + u + ' ' + e1);
            e1.printStackTrace();
            return;
        }
        if (G == null) {
            System.out.println("ERROR LOADING GRAMMAR");
            return;
        }
        try {
            R.commitChanges();
        }
        catch (Exception ge) {
            System.out.println("Grammar " + G.getName() + " caused a GrammarException when initially loaded");
            ge.printStackTrace();
            return;
        }
        System.out.println("Grammar loaded -- transforming");
        RuleGrammar[] RG = R.listRuleGrammars();
        RuleGrammar[] NRG = null;
        try {
            NRG = RecognizerUtilities.transform(RG, elimNULL, elimVOID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (RuleGrammar grammar : NRG) {
            System.out.println("Grammar: " + grammar.getName());
            for (String rname : grammar.listRuleNames()) {
                System.out.print('<' + rname + "> = ");
                Rule r = grammar.getRuleInternal(rname);
                System.out.println(r);
            }
            System.out.println("");
            System.out.println("");
        }
    }

    static Rule transform(Rule r, RuleGrammar[] RGL, boolean en, boolean ev) {
        if (r instanceof RuleSequence) {
            RuleSequence rs = (RuleSequence)r;
            Rule[] rarry = rs.getRules();
            if (rarry == null || rarry.length == 0) {
                return null;
            }
            int cnull = 0;
            for (int i = 0; i < rarry.length; ++i) {
                Rule r1 = RecognizerUtilities.transform(rarry[i], RGL, en, ev);
                RuleState s1 = new RuleState(r1, RGL);
                if (ev && s1.isVoid) {
                    return RuleName.VOID;
                }
                if ((!en || !s1.isNull) && r1 == rarry[i]) continue;
                if (rs == r) {
                    rs = (RuleSequence)rs.copy();
                    rarry = rs.getRules();
                }
                if (en && s1.isNull) {
                    ++cnull;
                    r1 = null;
                }
                rarry[i] = r1;
                rs.setRules(rarry);
            }
            if (cnull == 0) {
                return rs;
            }
            if (cnull == rarry.length) {
                return RuleName.NULL;
            }
            Rule[] barry = new Rule[rarry.length - cnull];
            int j = 0;
            for (Rule rule : rarry) {
                if (rule == null) continue;
                barry[j++] = rule;
            }
            rs.setRules(barry);
            return rs;
        }
        if (r instanceof RuleAlternatives) {
            RuleAlternatives ra = (RuleAlternatives)r;
            Rule[] rarry = ra.getRules();
            if (rarry == null || rarry.length == 0) {
                return null;
            }
            int cnull = 0;
            int cvoid = 0;
            for (int i = 0; i < rarry.length; ++i) {
                Rule r1 = RecognizerUtilities.transform(rarry[i], RGL, en, ev);
                RuleState s1 = new RuleState(r1, RGL);
                if (!(en && s1.isNull || ev && s1.isVoid) && r1 == rarry[i]) continue;
                if (ra == r) {
                    ra = (RuleAlternatives)ra.copy();
                    rarry = ra.getRules();
                }
                if (en && s1.isNull) {
                    ++cnull;
                    r1 = null;
                }
                if (ev && s1.isVoid) {
                    ++cvoid;
                    r1 = null;
                }
                rarry[i] = r1;
                ra.setRules(rarry);
            }
            if (cnull == 0 && cvoid == 0) {
                return ra;
            }
            if (cvoid == rarry.length) {
                return RuleName.VOID;
            }
            if (cvoid + cnull == rarry.length) {
                return RuleName.NULL;
            }
            Rule[] barry = new Rule[rarry.length - (cnull + cvoid)];
            int j = 0;
            for (Rule rule : rarry) {
                if (rule == null) continue;
                barry[j++] = rule;
            }
            ra.setRules(barry);
            if (cnull > 0) {
                return new RuleCount(ra, RuleCount.OPTIONAL);
            }
            return ra;
        }
        if (r instanceof RuleCount) {
            RuleCount rc = (RuleCount)r;
            int rcount = rc.getCount();
            Rule r1 = rc.getRule();
            Rule r2 = RecognizerUtilities.transform(r1, RGL, en, ev);
            RuleState s1 = new RuleState(r2, RGL);
            if (ev && s1.isVoid) {
                if (rcount == RuleCount.ONCE_OR_MORE) {
                    return RuleName.VOID;
                }
                return RuleName.NULL;
            }
            if (en && s1.isNull) {
                return RuleName.NULL;
            }
            if (r1 == r2) {
                return rc;
            }
            return new RuleCount(r2, rcount);
        }
        if (r instanceof RuleTag) {
            RuleTag rtag = (RuleTag)r;
            Rule rtr = rtag.getRule();
            Rule r1 = RecognizerUtilities.transform(rtr, RGL, en, ev);
            RuleState s1 = new RuleState(r1, RGL);
            if (en && s1.isNull) {
                return RuleName.NULL;
            }
            if (ev && s1.isVoid) {
                return RuleName.VOID;
            }
            if (r1 == rtr) {
                return rtag;
            }
            return new RuleTag(r1, rtag.getTag());
        }
        return r;
    }

    static RuleGrammar[] transform(RuleGrammar[] RG, boolean eliminateNULL, boolean eliminateVOID) throws GrammarException {
        RuleGrammar[] NRG = (RuleGrammar[])RG.clone();
        boolean somethingchanged = true;
        boolean nochange = true;
        while (somethingchanged) {
            somethingchanged = false;
            for (int i = 0; i < NRG.length; ++i) {
                for (String rname : NRG[i].listRuleNames()) {
                    boolean isPublic;
                    Rule r = NRG[i].getRuleInternal(rname);
                    Rule nr = RecognizerUtilities.transform(r, NRG, eliminateNULL, eliminateVOID);
                    if (nr == r) continue;
                    nochange = false;
                    somethingchanged = true;
                    if (NRG[i] == RG[i]) {
                        NRG[i] = new BaseRuleGrammar(null, RG[i].getName());
                        RecognizerUtilities.copyGrammar(RG[i], NRG[i]);
                    }
                    try {
                        isPublic = NRG[i].isRulePublic(rname);
                    }
                    catch (IllegalArgumentException nse) {
                        throw new GrammarException(nse.toString(), null);
                    }
                    NRG[i].setRule(rname, nr, isPublic);
                }
            }
        }
        if (nochange) {
            return NRG;
        }
        ArrayList<Object> nr = new ArrayList<Object>();
        for (RuleGrammar grammar : NRG) {
            int k = 0;
            for (String rname : grammar.listRuleNames()) {
                Rule r1 = grammar.getRuleInternal(rname);
                RuleState s = new RuleState(r1, NRG);
                if (eliminateVOID && s.isVoid || eliminateNULL && s.isNull) {
                    grammar.deleteRule(rname);
                    continue;
                }
                ++k;
            }
            if (k <= 0) continue;
            nr.add(grammar);
        }
        return nr.toArray(new RuleGrammar[nr.size()]);
    }
}

