/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.recognition;

import com.sun.speech.engine.BaseEngine;
import com.sun.speech.engine.BaseEngineProperties;
import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.recognition.BaseGrammar;
import com.sun.speech.engine.recognition.BaseRecognizerAudioManager;
import com.sun.speech.engine.recognition.BaseResult;
import com.sun.speech.engine.recognition.BaseRuleGrammar;
import com.sun.speech.engine.recognition.RecognizerUtilities;
import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammar;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarFactory;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarManager;
import edu.cmu.sphinx.jsgf.parser.JSGFParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.speech.AudioManager;
import javax.speech.EngineException;
import javax.speech.EngineListener;
import javax.speech.EngineStateError;
import javax.speech.SpeechEvent;
import javax.speech.VendorDataException;
import javax.speech.recognition.DictationGrammar;
import javax.speech.recognition.Grammar;
import javax.speech.recognition.GrammarException;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.RecognizerEvent;
import javax.speech.recognition.RecognizerListener;
import javax.speech.recognition.RecognizerModeDesc;
import javax.speech.recognition.RecognizerProperties;
import javax.speech.recognition.Result;
import javax.speech.recognition.ResultEvent;
import javax.speech.recognition.ResultListener;
import javax.speech.recognition.ResultStateError;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleGrammar;
import javax.speech.recognition.RuleName;
import javax.speech.recognition.SpeakerManager;

public class BaseRecognizer
extends BaseEngine
implements Recognizer,
SpeechEventDispatcher {
    protected final List<ResultListener> resultListeners = new ArrayList<ResultListener>();
    protected boolean hasModalGrammars;
    protected boolean supportsNULL = true;
    protected boolean supportsVOID = true;
    protected boolean reloadAll;
    public JSGFRuleGrammarManager manager;
    HashMap<String, BaseRuleGrammar> grammars = new HashMap();

    public BaseRecognizer() {
        this(false, null);
    }

    public BaseRecognizer(RecognizerModeDesc mode) {
        this(false, mode);
    }

    public BaseRecognizer(JSGFRuleGrammarManager manager) {
        this.reloadAll = false;
        this.audioManager = new BaseRecognizerAudioManager();
        this.manager = manager;
    }

    public BaseRecognizer(boolean reloadAll, RecognizerModeDesc mode) {
        super(mode);
        this.reloadAll = reloadAll;
        this.audioManager = new BaseRecognizerAudioManager();
        this.manager = new JSGFRuleGrammarManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate() throws EngineException, EngineStateError {
        if (this.testEngineState(4L)) {
            return;
        }
        long[] states = this.setEngineState(-1L, 2L);
        this.postEngineAllocatingResources(states[0], states[1]);
        Object object = this.engineStateLock;
        synchronized (object) {
            long newState = 281479271678468L;
            states = this.setEngineState(-1L, newState);
        }
        this.postEngineAllocated(states[0], states[1]);
        this.handleAllocate();
    }

    @Override
    public void deallocate() throws EngineException, EngineStateError {
        if (this.testEngineState(1L)) {
            return;
        }
        this.releaseFocus();
        long[] states = this.setEngineState(-1L, 8L);
        this.postEngineDeallocatingResources(states[0], states[1]);
        states = this.setEngineState(-1L, 1L);
        this.postEngineDeallocated(states[0], states[1]);
        this.handleDeallocate();
    }

    @Override
    public AudioManager getAudioManager() {
        if (this.audioManager == null) {
            this.audioManager = new BaseRecognizerAudioManager();
        }
        return this.audioManager;
    }

    @Override
    public RuleGrammar newRuleGrammar(String name) throws IllegalArgumentException, EngineStateError {
        this.checkEngineState(9L);
        JSGFRuleGrammar jsgfGrammar = new JSGFRuleGrammar(name, this.manager);
        BaseRuleGrammar grammar = new BaseRuleGrammar(this, jsgfGrammar);
        this.grammars.put(name, grammar);
        return grammar;
    }

    @Override
    public RuleGrammar loadJSGF(Reader reader) throws GrammarException, IOException, EngineStateError {
        JSGFRuleGrammar jsgfGrammar;
        this.checkEngineState(9L);
        try {
            jsgfGrammar = JSGFParser.newGrammarFromJSGF((Reader)reader, (JSGFRuleGrammarFactory)new JSGFRuleGrammarFactory(this.manager));
        }
        catch (JSGFGrammarParseException e) {
            throw new GrammarException(e.getMessage());
        }
        BaseRuleGrammar grammar = new BaseRuleGrammar(this, jsgfGrammar);
        this.grammars.put(jsgfGrammar.getName(), grammar);
        return grammar;
    }

    @Override
    public RuleGrammar loadJSGF(URL baseURL, String grammarName) throws GrammarException, MalformedURLException, IOException, EngineStateError {
        this.checkEngineState(9L);
        return this.loadJSGF(baseURL, grammarName, true, false, null);
    }

    private static URL grammarNameToURL(URL baseURL, String grammarName) throws MalformedURLException {
        URL grammarURL;
        block4: {
            grammarName = grammarName.replace('.', '/');
            StringBuilder sb = new StringBuilder();
            if (baseURL != null) {
                sb.append(baseURL);
                if (sb.charAt(sb.length() - 1) != '/') {
                    sb.append('/');
                }
            }
            sb.append(grammarName).append(".gram");
            String urlstr = sb.toString();
            grammarURL = null;
            try {
                grammarURL = new URL(urlstr);
            }
            catch (MalformedURLException me) {
                grammarURL = ClassLoader.getSystemResource(urlstr);
                if (grammarURL != null) break block4;
                throw new MalformedURLException(urlstr);
            }
        }
        return grammarURL;
    }

    @Override
    public RuleGrammar loadJSGF(URL context, String grammarName, boolean loadImports, boolean reloadGrammars, Vector grammarsList) throws GrammarException, MalformedURLException, IOException, EngineStateError {
        JSGFRuleGrammar jsgfGrammar;
        this.checkEngineState(9L);
        URL grammarURL = BaseRecognizer.grammarNameToURL(context, grammarName);
        try {
            jsgfGrammar = JSGFParser.newGrammarFromJSGF((URL)grammarURL, (JSGFRuleGrammarFactory)new JSGFRuleGrammarFactory(this.manager));
        }
        catch (JSGFGrammarParseException e) {
            throw new GrammarException(e.getMessage());
        }
        BaseRuleGrammar grammar = new BaseRuleGrammar(this, jsgfGrammar);
        this.grammars.put(jsgfGrammar.getName(), grammar);
        if (loadImports) {
            this.loadImports(grammar, context, true, reloadGrammars);
        }
        return grammar;
    }

    @Override
    public RuleGrammar getRuleGrammar(String name) throws EngineStateError {
        JSGFRuleGrammar jsgfGrammar;
        this.checkEngineState(9L);
        BaseRuleGrammar grammar = this.grammars.get(name);
        if (grammar == null && (jsgfGrammar = this.manager.retrieveGrammar(name)) != null) {
            grammar = new BaseRuleGrammar(this, jsgfGrammar);
            this.grammars.put(jsgfGrammar.getName(), grammar);
        }
        return grammar;
    }

    @Override
    public RuleGrammar[] listRuleGrammars() throws EngineStateError {
        this.checkEngineState(9L);
        return this.grammars.values().toArray(new RuleGrammar[this.grammars.size()]);
    }

    @Override
    public void deleteRuleGrammar(RuleGrammar grammar) throws IllegalArgumentException, EngineStateError {
        this.checkEngineState(9L);
        this.manager.remove(grammar.getName());
    }

    @Override
    public DictationGrammar getDictationGrammar(String name) throws EngineStateError {
        this.checkEngineState(9L);
        return null;
    }

    @Override
    public void commitChanges() throws GrammarException, EngineStateError {
        long[] states;
        this.checkEngineState(9L);
        boolean goBackToListening = false;
        if (this.testEngineState(0x100000000L)) {
            goBackToListening = true;
            states = this.setEngineState(0x300000000L, 0x400000000L);
            this.postRecognizerSuspended(states[0], states[1]);
        }
        this.linkGrammars();
        this.notifyGrammarActivation();
        if (goBackToListening) {
            states = this.setEngineState(0x600000000L, 0x100000000L);
            this.postChangesCommitted(states[0], states[1], null);
        }
    }

    @Override
    public void suspend() throws EngineStateError {
        this.checkEngineState(9L);
        if (this.testEngineState(0x400000000L)) {
            return;
        }
        long[] states = this.setEngineState(0x300000000L, 0x400000000L);
        this.postRecognizerSuspended(states[0], states[1]);
    }

    @Override
    public void forceFinalize(boolean flush) throws EngineStateError {
        this.checkEngineState(9L);
        throw new RuntimeException("forceFinalize not yet implemented.");
    }

    @Override
    public void requestFocus() throws EngineStateError {
        this.checkEngineState(9L);
        if (this.testEngineState(0x1000000000000L)) {
            return;
        }
        long[] states = this.setEngineState(0x2000000000000L, 0x1000000000000L);
        this.postFocusGained(states[0], states[1]);
        this.notifyGrammarActivation();
    }

    @Override
    public void releaseFocus() throws EngineStateError {
        this.checkEngineState(9L);
        if (this.testEngineState(0x2000000000000L)) {
            return;
        }
        long[] states = this.setEngineState(0x1000000000000L, 0x2000000000000L);
        this.postFocusLost(states[0], states[1]);
        this.notifyGrammarActivation();
    }

    @Override
    public void addResultListener(ResultListener listener) {
        if (!this.resultListeners.contains(listener)) {
            this.resultListeners.add(listener);
        }
    }

    @Override
    public void removeResultListener(ResultListener listener) {
        this.resultListeners.remove(listener);
    }

    @Override
    public RecognizerProperties getRecognizerProperties() {
        return (RecognizerProperties)this.getEngineProperties();
    }

    @Override
    public SpeakerManager getSpeakerManager() {
        return null;
    }

    @Override
    public Grammar readVendorGrammar(InputStream input) throws VendorDataException, IOException, EngineStateError {
        this.checkEngineState(9L);
        BaseGrammar G = null;
        try {
            ObjectInputStream p = new ObjectInputStream(input);
            G = (BaseGrammar)p.readObject();
        }
        catch (Exception e) {
            throw new VendorDataException("ERROR: readVendorGrammar: " + e);
        }
        return G;
    }

    @Override
    public void writeVendorGrammar(OutputStream output, Grammar gram) throws IOException, EngineStateError {
        this.checkEngineState(9L);
        ObjectOutputStream p = new ObjectOutputStream(output);
        p.writeObject(gram);
    }

    @Override
    public Result readVendorResult(InputStream output) throws VendorDataException, IOException, EngineStateError {
        this.checkEngineState(9L);
        BaseResult res = null;
        try {
            ObjectInputStream p = new ObjectInputStream(output);
            res = (BaseResult)p.readObject();
        }
        catch (Exception e) {
            throw new VendorDataException("ERROR: readVendorResult: " + e);
        }
        return res;
    }

    @Override
    public void writeVendorResult(OutputStream output, Result result) throws IOException, ResultStateError, EngineStateError {
        this.checkEngineState(9L);
        ObjectOutputStream p = new ObjectOutputStream(output);
        p.writeObject(result);
    }

    public void postAudioReleased(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 806));
    }

    public void fireAudioReleased(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.audioReleased(event);
        }
    }

    public void postGrammarFinalized(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 803));
    }

    public void fireGrammarFinalized(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.grammarFinalized(event);
        }
    }

    public void postResultAccepted(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 804));
    }

    public void fireResultAccepted(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultAccepted(event);
        }
    }

    public void postResultCreated(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 801));
    }

    public void fireResultCreated(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultCreated(event);
        }
    }

    public void postResultRejected(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 805));
    }

    public void fireResultRejected(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultRejected(event);
        }
    }

    public void postResultUpdated(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 802));
    }

    public void fireResultUpdated(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultUpdated(event);
        }
    }

    public void postTrainingInfoReleased(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 807));
    }

    public void fireTrainingInfoReleased(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.trainingInfoReleased(event);
        }
    }

    public void rejectUtterance() {
        BaseResult R = new BaseResult(null);
        this.postResultCreated(R);
        R.postResultRejected();
        this.postResultRejected(R);
    }

    protected void postChangesCommitted(long oldState, long newState, GrammarException ge) {
        SpeechEventUtilities.postSpeechEvent(this, new RecognizerEvent(this, 1203, oldState, newState, ge));
    }

    public void fireChangesCommitted(RecognizerEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        for (EngineListener el : this.engineListeners) {
            if (!(el instanceof RecognizerListener)) continue;
            ((RecognizerListener)el).changesCommitted(event);
        }
    }

    protected void postFocusGained(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new RecognizerEvent(this, 1204, oldState, newState, null));
    }

    public void fireFocusGained(RecognizerEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        for (EngineListener el : this.engineListeners) {
            if (!(el instanceof RecognizerListener)) continue;
            ((RecognizerListener)el).focusGained(event);
        }
    }

    protected void postFocusLost(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new RecognizerEvent(this, 1205, oldState, newState, null));
    }

    public void fireFocusLost(RecognizerEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        for (EngineListener el : this.engineListeners) {
            if (!(el instanceof RecognizerListener)) continue;
            ((RecognizerListener)el).focusLost(event);
        }
    }

    protected void postRecognizerProcessing(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new RecognizerEvent(this, 1200, oldState, newState, null));
    }

    public void fireRecognizerProcessing(RecognizerEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        for (EngineListener el : this.engineListeners) {
            if (!(el instanceof RecognizerListener)) continue;
            ((RecognizerListener)el).recognizerProcessing(event);
        }
    }

    protected void postRecognizerSuspended(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new RecognizerEvent(this, 1202, oldState, newState, null));
    }

    public void fireRecognizerSuspended(RecognizerEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        for (EngineListener el : this.engineListeners) {
            if (!(el instanceof RecognizerListener)) continue;
            ((RecognizerListener)el).recognizerSuspended(event);
        }
    }

    protected void commitChangeInternal() {
        boolean haveChanges = false;
        ArrayList<String> enabled = new ArrayList<String>();
        RuleGrammar[] grammarArray = this.listRuleGrammars();
        if (!this.supportsNULL || !this.supportsVOID) {
            try {
                grammarArray = RecognizerUtilities.transform(grammarArray, !this.supportsNULL, !this.supportsVOID);
            }
            catch (GrammarException e) {
                e.printStackTrace();
                return;
            }
        }
        for (RuleGrammar grammar : grammarArray) {
            BaseRuleGrammar JG = (BaseRuleGrammar)grammar;
            if (!JG.grammarChanged) continue;
            haveChanges = true;
            break;
        }
        if (haveChanges) {
            this.startGrammarChanges();
        }
        for (RuleGrammar ruleGrammar : grammarArray) {
            String grammarName = ruleGrammar.getName();
            BaseRuleGrammar grammar = (BaseRuleGrammar)ruleGrammar;
            for (String ruleName : grammar.listRuleNames()) {
                if (grammar.isEnabled(ruleName)) {
                    enabled.add(grammarName + '_' + ruleName);
                }
                if (!haveChanges || !grammar.isRuleChanged(ruleName) && !this.reloadAll) continue;
                grammar.setRuleChanged(ruleName, false);
                boolean isPublic = grammar.isRulePublic(ruleName);
                Rule rule = grammar.getRule(ruleName);
                this.changeRule(grammarName, ruleName, rule, isPublic);
            }
            grammar.grammarChanged = false;
            grammar.postGrammarChangesCommitted();
        }
        if (haveChanges) {
            this.endGrammarChanges();
        }
    }

    protected void startGrammarChanges() {
    }

    protected void endGrammarChanges() {
    }

    protected void changeEnabled(List<String> enabled) {
    }

    protected void changeRule(String gname, String ruleName, Rule rule, boolean isPublic) {
    }

    public void loadAllImports() throws GrammarException, IOException {
        for (BaseRuleGrammar grammar : this.grammars.values()) {
            this.loadImports(grammar, null, false, false);
        }
    }

    private void loadImports(RuleGrammar grammar, URL context, boolean recurse, boolean reload) throws GrammarException, IOException {
        for (RuleName ruleName : grammar.listImports()) {
            String grammarName = ruleName.getFullGrammarName();
            RuleGrammar importedGrammar = this.getRuleGrammar(grammarName);
            if (importedGrammar == null) {
                importedGrammar = this.loadJSGF(context, ruleName.getFullGrammarName());
            }
            if (importedGrammar == null || !recurse) continue;
            this.loadImports(importedGrammar, context, recurse, reload);
        }
        this.loadFullQualifiedRules(grammar, context, recurse, reload);
    }

    private void loadFullQualifiedRules(RuleGrammar grammar, URL context, boolean recurse, boolean reload) throws GrammarException, IOException {
        for (String ruleName : grammar.listRuleNames()) {
            String rule = grammar.getRuleInternal(ruleName).toString();
            int index = 0;
            while (index < rule.length() && (index = rule.indexOf(60, index)) >= 0) {
                RuleName extractedRuleName = new RuleName(rule.substring(index + 1, rule.indexOf(62, index + 1)).trim());
                index = rule.indexOf(62, index) + 1;
                if (extractedRuleName.getFullGrammarName() == null) continue;
                String grammarName = extractedRuleName.getFullGrammarName();
                RuleGrammar importedGrammar = this.getRuleGrammar(grammarName);
                if (importedGrammar == null) {
                    importedGrammar = this.loadJSGF(context, grammarName);
                }
                if (importedGrammar == null || !recurse) continue;
                this.loadImports(importedGrammar, context, recurse, reload);
            }
        }
    }

    protected void linkGrammars() throws GrammarException {
        try {
            this.manager.linkGrammars();
        }
        catch (JSGFGrammarException e) {
            throw new GrammarException(e.getMessage());
        }
    }

    protected boolean isActive(Grammar grammar) {
        if (!grammar.isEnabled()) {
            return false;
        }
        if (grammar.getActivationMode() == 902) {
            return true;
        }
        if (this.testEngineState(0x1000000000000L)) {
            if (grammar.getActivationMode() == 901) {
                return true;
            }
            if (!this.hasModalGrammars) {
                return true;
            }
        }
        return false;
    }

    protected void notifyGrammarActivation() {
        for (BaseRuleGrammar grammar : this.grammars.values()) {
            boolean active = this.isActive(grammar);
            if (active == grammar.grammarActive) continue;
            grammar.grammarActive = active;
            if (active) {
                grammar.postGrammarActivated();
                continue;
            }
            grammar.postGrammarDeactivated();
        }
    }

    @Override
    protected BaseEngineProperties createEngineProperties() {
        return null;
    }

    @Override
    protected void handleResume() {
    }

    @Override
    protected void handlePause() {
    }

    @Override
    protected void handleAllocate() throws EngineException {
    }

    @Override
    protected void handleDeallocate() throws EngineException {
    }

    @Override
    public void dispatchSpeechEvent(SpeechEvent event) {
        switch (event.getId()) {
            case 1203: {
                this.fireChangesCommitted((RecognizerEvent)event);
                break;
            }
            case 1204: {
                this.fireFocusGained((RecognizerEvent)event);
                break;
            }
            case 1205: {
                this.fireFocusLost((RecognizerEvent)event);
                break;
            }
            case 1200: {
                this.fireRecognizerProcessing((RecognizerEvent)event);
                break;
            }
            case 1202: {
                this.fireRecognizerSuspended((RecognizerEvent)event);
                break;
            }
            case 806: {
                this.fireAudioReleased((ResultEvent)event);
                break;
            }
            case 803: {
                this.fireGrammarFinalized((ResultEvent)event);
                break;
            }
            case 804: {
                this.fireResultAccepted((ResultEvent)event);
                break;
            }
            case 801: {
                this.fireResultCreated((ResultEvent)event);
                break;
            }
            case 805: {
                this.fireResultRejected((ResultEvent)event);
                break;
            }
            case 802: {
                this.fireResultUpdated((ResultEvent)event);
                break;
            }
            case 807: {
                this.fireTrainingInfoReleased((ResultEvent)event);
                break;
            }
            default: {
                super.dispatchSpeechEvent(event);
            }
        }
    }
}

